/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.ModelUtils;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ProjectModel
implements Serializable,
Comparable<ProjectModel> {
    private static final long serialVersionUID = 1L;
    public final String name;
    public String title;
    public String description;
    public final Set<String> repositories = new HashSet<String>();
    public String projectMarkdown;
    public String repositoriesMarkdown;
    public Date lastChange;
    public final boolean isRoot;

    public ProjectModel(String name) {
        this(name, false);
    }

    public ProjectModel(String name, boolean isRoot) {
        this.name = name;
        this.isRoot = isRoot;
        this.lastChange = new Date(0L);
        this.title = "";
        this.description = "";
    }

    public boolean isUserProject() {
        return ModelUtils.isPersonalRepository(this.name);
    }

    public boolean hasRepository(String name) {
        return this.repositories.contains(name.toLowerCase());
    }

    public void addRepository(String name) {
        this.repositories.add(name.toLowerCase());
    }

    public void addRepository(RepositoryModel model) {
        this.repositories.add(model.name.toLowerCase());
        if (this.lastChange.before(model.lastChange)) {
            this.lastChange = model.lastChange;
        }
    }

    public void addRepositories(Collection<String> names) {
        for (String name : names) {
            this.repositories.add(name.toLowerCase());
        }
    }

    public void removeRepository(String name) {
        this.repositories.remove(name.toLowerCase());
    }

    public String getDisplayName() {
        return StringUtils.isEmpty(this.title) ? this.name : this.title;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ProjectModel o) {
        return this.name.compareTo(o.name);
    }
}

