/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.RepositoryCommit;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.ReceiveCommand;

public class RefLogEntry
implements Serializable,
Comparable<RefLogEntry> {
    private static final long serialVersionUID = 1L;
    public final String repository;
    public final Date date;
    public final UserModel user;
    private final Set<RepositoryCommit> commits;
    protected final Map<String, ReceiveCommand.Type> refUpdates;
    protected final Map<String, String> refIdChanges;
    private int authorCount;

    public RefLogEntry(String repository, Date date, UserModel user) {
        this.repository = repository;
        this.date = date;
        this.user = user;
        this.commits = new LinkedHashSet<RepositoryCommit>();
        this.refUpdates = new HashMap<String, ReceiveCommand.Type>();
        this.refIdChanges = new HashMap<String, String>();
        this.authorCount = -1;
    }

    public void updateRef(String ref, ReceiveCommand.Type type) {
        if (!this.refUpdates.containsKey(ref)) {
            this.refUpdates.put(ref, type);
        }
    }

    public void updateRef(String ref, ReceiveCommand.Type type, String oldId, String newId) {
        if (!this.refUpdates.containsKey(ref)) {
            this.refUpdates.put(ref, type);
            this.refIdChanges.put(ref, oldId + "-" + newId);
        }
    }

    public String getOldId(String ref) {
        String change = this.refIdChanges.get(ref);
        if (StringUtils.isEmpty(change)) {
            return null;
        }
        return change.split("-")[0];
    }

    public String getNewId(String ref) {
        String change = this.refIdChanges.get(ref);
        if (StringUtils.isEmpty(change)) {
            return null;
        }
        return change.split("-")[1];
    }

    public ReceiveCommand.Type getChangeType(String ref) {
        ReceiveCommand.Type type = this.refUpdates.get(ref);
        return type;
    }

    public RepositoryCommit addCommit(String branch, RevCommit commit) {
        RepositoryCommit commitModel = new RepositoryCommit(this.repository, branch, commit);
        if (this.commits.add(commitModel)) {
            this.authorCount = -1;
            return commitModel;
        }
        return null;
    }

    public RepositoryCommit addCommit(RepositoryCommit commit) {
        if (this.commits.add(commit)) {
            this.authorCount = -1;
            return commit;
        }
        return null;
    }

    public void addCommits(List<RepositoryCommit> list) {
        this.commits.addAll(list);
        this.authorCount = -1;
    }

    public boolean isNonFastForward() {
        for (Map.Entry<String, ReceiveCommand.Type> entry : this.refUpdates.entrySet()) {
            if (!ReceiveCommand.Type.UPDATE_NONFASTFORWARD.equals((Object)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isNonFastForward(String ref) {
        ReceiveCommand.Type type = this.refUpdates.get(ref);
        if (type == null) {
            return false;
        }
        return ReceiveCommand.Type.UPDATE_NONFASTFORWARD.equals((Object)type);
    }

    public boolean isDelete(String ref) {
        ReceiveCommand.Type type = this.refUpdates.get(ref);
        if (type == null) {
            return false;
        }
        return ReceiveCommand.Type.DELETE.equals((Object)type);
    }

    public List<String> getChangedRefs() {
        return new ArrayList<String>(this.refUpdates.keySet());
    }

    public List<String> getChangedBranches() {
        return this.getChangedRefs("refs/heads/");
    }

    public List<String> getChangedTags() {
        return this.getChangedRefs("refs/tags/");
    }

    protected List<String> getChangedRefs(String baseRef) {
        HashSet<String> refs = new HashSet<String>();
        for (String ref : this.refUpdates.keySet()) {
            if (baseRef != null && !ref.startsWith(baseRef)) continue;
            refs.add(ref);
        }
        ArrayList<String> list = new ArrayList<String>(refs);
        Collections.sort(list);
        return list;
    }

    public int getAuthorCount() {
        if (this.authorCount == -1) {
            HashSet<String> authors = new HashSet<String>();
            for (RepositoryCommit commit : this.commits) {
                String name = commit.getAuthorIdent().getName();
                authors.add(name);
            }
            this.authorCount = authors.size();
        }
        return this.authorCount;
    }

    public int getCommitCount() {
        return this.commits.size();
    }

    public List<RepositoryCommit> getCommits() {
        ArrayList<RepositoryCommit> list = new ArrayList<RepositoryCommit>(this.commits);
        Collections.sort(list);
        return list;
    }

    public List<RepositoryCommit> getCommits(String ref) {
        ArrayList<RepositoryCommit> list = new ArrayList<RepositoryCommit>();
        for (RepositoryCommit commit : this.commits) {
            if (!commit.branch.equals(ref)) continue;
            list.add(commit);
        }
        Collections.sort(list);
        return list;
    }

    public PersonIdent getCommitterIdent() {
        return new PersonIdent(this.user.getDisplayName(), this.user.emailAddress == null ? this.user.username : this.user.emailAddress);
    }

    public PersonIdent getAuthorIdent() {
        if (this.getAuthorCount() == 1) {
            return this.getCommits().get(0).getAuthorIdent();
        }
        return this.getCommitterIdent();
    }

    @Override
    public int compareTo(RefLogEntry o) {
        return o.date.compareTo(this.date);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("{0,date,yyyy-MM-dd HH:mm}: {1} pushed {2,number,0} commit{3} to {4} ", this.date, this.user.getDisplayName(), this.commits.size(), this.commits.size() == 1 ? "" : "s", this.repository));
        for (Map.Entry<String, ReceiveCommand.Type> entry : this.refUpdates.entrySet()) {
            String ref = entry.getKey();
            ReceiveCommand.Type type = entry.getValue();
            sb.append("\n  ").append(ref).append(' ').append(type.name()).append('\n');
            for (RepositoryCommit commit : this.getCommits(ref)) {
                sb.append("    ").append(commit.toString()).append('\n');
            }
        }
        return sb.toString();
    }
}

