/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.RefModel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class RepositoryCommit
implements Serializable,
Comparable<RepositoryCommit> {
    private static final long serialVersionUID = 1L;
    public final String repository;
    public final String branch;
    private final RevCommit commit;
    private List<RefModel> refs;

    public RepositoryCommit(String repository, String branch, RevCommit commit) {
        this.repository = repository;
        this.branch = branch;
        this.commit = commit;
    }

    public void setRefs(List<RefModel> refs) {
        this.refs = refs;
    }

    public List<RefModel> getRefs() {
        return this.refs;
    }

    public ObjectId getId() {
        return this.commit.getId();
    }

    public String getName() {
        return this.commit.getName();
    }

    public String getShortName() {
        return this.commit.getName().substring(0, 8);
    }

    public String getShortMessage() {
        return this.commit.getShortMessage();
    }

    public Date getCommitDate() {
        return new Date((long)this.commit.getCommitTime() * 1000L);
    }

    public int getParentCount() {
        return this.commit.getParentCount();
    }

    public RevCommit[] getParents() {
        return this.commit.getParents();
    }

    public PersonIdent getAuthorIdent() {
        return this.commit.getAuthorIdent();
    }

    public PersonIdent getCommitterIdent() {
        return this.commit.getCommitterIdent();
    }

    public boolean equals(Object o) {
        if (o instanceof RepositoryCommit) {
            RepositoryCommit commit = (RepositoryCommit)o;
            return this.repository.equals(commit.repository) && this.getName().equals(commit.getName());
        }
        return false;
    }

    public int hashCode() {
        return (this.repository + this.commit).hashCode();
    }

    @Override
    public int compareTo(RepositoryCommit o) {
        if (this.commit.getCommitTime() > o.commit.getCommitTime()) {
            return -1;
        }
        if (this.commit.getCommitTime() < o.commit.getCommitTime()) {
            return 1;
        }
        return 0;
    }

    public RepositoryCommit clone(String withRef) {
        return new RepositoryCommit(this.repository, withRef, this.commit);
    }

    public String toString() {
        return MessageFormat.format("{0} {1} {2,date,yyyy-MM-dd HH:mm} {3} {4}", this.getShortName(), this.branch, this.getCommitterIdent().getWhen(), this.getAuthorIdent().getName(), this.getShortMessage());
    }
}

