/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.Constants;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.ModelUtils;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RepositoryModel
implements Serializable,
Comparable<RepositoryModel> {
    private static final long serialVersionUID = 1L;
    public String name;
    public String description;
    public List<String> owners;
    public Date lastChange;
    public String lastChangeAuthor;
    public boolean hasCommits;
    public boolean showRemoteBranches;
    public boolean useIncrementalPushTags;
    public String incrementalPushTagPrefix;
    public Constants.AccessRestrictionType accessRestriction;
    public Constants.AuthorizationControl authorizationControl;
    public boolean allowAuthenticated;
    public boolean isFrozen;
    public Constants.FederationStrategy federationStrategy;
    public List<String> federationSets;
    public boolean isFederated;
    public boolean skipSizeCalculation;
    public boolean skipSummaryMetrics;
    public String frequency;
    public boolean isBare;
    public boolean isMirror;
    public String origin;
    public String HEAD;
    public List<String> availableRefs;
    public List<String> indexedBranches;
    public String size;
    public List<String> preReceiveScripts;
    public List<String> postReceiveScripts;
    public List<String> mailingLists;
    public Map<String, String> customFields;
    public String projectPath;
    private String displayName;
    public boolean allowForks;
    public Set<String> forks;
    public String originRepository;
    public boolean verifyCommitter;
    public String gcThreshold;
    public int gcPeriod;
    public int maxActivityCommits;
    public List<String> metricAuthorExclusions;
    public Constants.CommitMessageRenderer commitMessageRenderer;
    public boolean acceptNewPatchsets;
    public boolean acceptNewTickets;
    public boolean requireApproval;
    public String mergeTo;
    public Constants.MergeType mergeType;
    public transient boolean isCollectingGarbage;
    public Date lastGC;
    public String sparkleshareId;

    public RepositoryModel() {
        this("", "", "", new Date(0L));
    }

    public RepositoryModel(String name, String description, String owner, Date lastchange) {
        this.name = name;
        this.description = description;
        this.lastChange = lastchange;
        this.accessRestriction = Constants.AccessRestrictionType.NONE;
        this.authorizationControl = Constants.AuthorizationControl.NAMED;
        this.federationSets = new ArrayList<String>();
        this.federationStrategy = Constants.FederationStrategy.FEDERATE_THIS;
        this.projectPath = StringUtils.getFirstPathElement(name);
        this.owners = new ArrayList<String>();
        this.isBare = true;
        this.acceptNewTickets = true;
        this.acceptNewPatchsets = true;
        this.mergeType = Constants.MergeType.DEFAULT_MERGE_TYPE;
        this.addOwner(owner);
    }

    public List<String> getLocalBranches() {
        if (ArrayUtils.isEmpty(this.availableRefs)) {
            return new ArrayList<String>();
        }
        ArrayList<String> localBranches = new ArrayList<String>();
        for (String ref : this.availableRefs) {
            if (!ref.startsWith("refs/heads")) continue;
            localBranches.add(ref);
        }
        return localBranches;
    }

    public void addFork(String repository) {
        if (this.forks == null) {
            this.forks = new TreeSet<String>();
        }
        this.forks.add(repository);
    }

    public void removeFork(String repository) {
        if (this.forks == null) {
            return;
        }
        this.forks.remove(repository);
    }

    public void resetDisplayName() {
        this.displayName = null;
    }

    public String getRID() {
        return StringUtils.getSHA1(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RepositoryModel) {
            return this.name.equals(((RepositoryModel)o).name);
        }
        return false;
    }

    public String toString() {
        if (this.displayName == null) {
            this.displayName = StringUtils.stripDotGit(this.name);
        }
        return this.displayName;
    }

    @Override
    public int compareTo(RepositoryModel o) {
        return StringUtils.compareRepositoryNames(this.name, o.name);
    }

    public boolean isFork() {
        return !StringUtils.isEmpty(this.originRepository);
    }

    public boolean isOwner(String username) {
        if (StringUtils.isEmpty(username) || ArrayUtils.isEmpty(this.owners)) {
            return this.isUsersPersonalRepository(username);
        }
        return this.owners.contains(username.toLowerCase()) || this.isUsersPersonalRepository(username);
    }

    public boolean isPersonalRepository() {
        return !StringUtils.isEmpty(this.projectPath) && ModelUtils.isPersonalRepository(this.projectPath);
    }

    public boolean isUsersPersonalRepository(String username) {
        return !StringUtils.isEmpty(this.projectPath) && ModelUtils.isUsersPersonalRepository(username, this.projectPath);
    }

    public boolean allowAnonymousView() {
        return !this.accessRestriction.atLeast(Constants.AccessRestrictionType.VIEW);
    }

    public boolean isShowActivity() {
        return this.maxActivityCommits > -1;
    }

    public boolean isSparkleshared() {
        return !StringUtils.isEmpty(this.sparkleshareId);
    }

    public RepositoryModel cloneAs(String cloneName) {
        RepositoryModel clone = new RepositoryModel();
        clone.originRepository = this.name;
        clone.name = cloneName;
        clone.projectPath = StringUtils.getFirstPathElement(cloneName);
        clone.isBare = true;
        clone.description = this.description;
        clone.accessRestriction = Constants.AccessRestrictionType.PUSH;
        clone.authorizationControl = Constants.AuthorizationControl.NAMED;
        clone.federationStrategy = this.federationStrategy;
        clone.showRemoteBranches = false;
        clone.allowForks = false;
        clone.acceptNewPatchsets = false;
        clone.acceptNewTickets = false;
        clone.skipSizeCalculation = this.skipSizeCalculation;
        clone.skipSummaryMetrics = this.skipSummaryMetrics;
        clone.sparkleshareId = this.sparkleshareId;
        return clone;
    }

    public void addOwner(String username) {
        String name;
        if (!StringUtils.isEmpty(username) && !this.owners.contains(name = username.toLowerCase())) {
            this.owners.add(name);
        }
    }

    public void removeOwner(String username) {
        if (!StringUtils.isEmpty(username)) {
            this.owners.remove(username.toLowerCase());
        }
    }

    public void addOwners(Collection<String> usernames) {
        if (!ArrayUtils.isEmpty(usernames)) {
            for (String username : usernames) {
                this.addOwner(username);
            }
        }
    }

    public void removeOwners(Collection<String> usernames) {
        if (!ArrayUtils.isEmpty(this.owners)) {
            for (String username : usernames) {
                this.removeOwner(username);
            }
        }
    }
}

