/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.Constants;
import com.gitblit.models.UserRepositoryPreferences;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class UserPreferences
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String username;
    private String locale;
    private Boolean emailMeOnMyTicketChanges;
    private Constants.Transport transport;
    private final Map<String, UserRepositoryPreferences> repositoryPreferences = new TreeMap<String, UserRepositoryPreferences>();

    public UserPreferences(String username) {
        this.username = username;
    }

    public Locale getLocale() {
        if (StringUtils.isEmpty(this.locale)) {
            return null;
        }
        int underscore = this.locale.indexOf(95);
        if (underscore > 0) {
            String lang = this.locale.substring(0, underscore);
            String cc = this.locale.substring(underscore + 1);
            return new Locale(lang, cc);
        }
        return new Locale(this.locale);
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public UserRepositoryPreferences getRepositoryPreferences(String repositoryName) {
        String key = repositoryName.toLowerCase();
        if (!this.repositoryPreferences.containsKey(key)) {
            UserRepositoryPreferences prefs = new UserRepositoryPreferences();
            prefs.username = this.username;
            prefs.repositoryName = repositoryName;
            this.repositoryPreferences.put(key, prefs);
        }
        return this.repositoryPreferences.get(key);
    }

    public void setRepositoryPreferences(UserRepositoryPreferences pref) {
        this.repositoryPreferences.put(pref.repositoryName.toLowerCase(), pref);
    }

    public boolean isStarredRepository(String repository) {
        if (this.repositoryPreferences == null) {
            return false;
        }
        String key = repository.toLowerCase();
        if (this.repositoryPreferences.containsKey(key)) {
            UserRepositoryPreferences pref = this.repositoryPreferences.get(key);
            return pref.starred;
        }
        return false;
    }

    public List<String> getStarredRepositories() {
        ArrayList<String> list = new ArrayList<String>();
        for (UserRepositoryPreferences prefs : this.repositoryPreferences.values()) {
            if (!prefs.starred) continue;
            list.add(prefs.repositoryName);
        }
        Collections.sort(list);
        return list;
    }

    public boolean isEmailMeOnMyTicketChanges() {
        if (this.emailMeOnMyTicketChanges == null) {
            return true;
        }
        return this.emailMeOnMyTicketChanges;
    }

    public void setEmailMeOnMyTicketChanges(boolean value) {
        this.emailMeOnMyTicketChanges = value;
    }

    public Constants.Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Constants.Transport transport) {
        this.transport = transport;
    }
}

