/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.service;

import com.gitblit.ConfigUserService;
import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.IUserService;
import com.gitblit.manager.IGitblit;
import com.gitblit.models.FederationModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.FederationUtils;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FederationPullService
implements Runnable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final IGitblit gitblit;
    private final List<FederationModel> registrations;

    public FederationPullService(IGitblit gitblit, FederationModel registration) {
        this(gitblit, Arrays.asList(registration));
    }

    public FederationPullService(IGitblit gitblit, List<FederationModel> registrations) {
        this.gitblit = gitblit;
        this.registrations = registrations;
    }

    public abstract void reschedule(FederationModel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (FederationModel registration : this.registrations) {
            Constants.FederationPullStatus was = registration.getLowestStatus();
            try {
                Date now = new Date(System.currentTimeMillis());
                this.pull(registration);
                this.sendStatusAcknowledgment(registration);
                registration.lastPull = now;
                Constants.FederationPullStatus is = registration.getLowestStatus();
                if (is.ordinal() >= was.ordinal()) continue;
                this.logger.warn("Federation pull status of {0} is now {1}", (Object)registration.name, (Object)is.name());
                if (!registration.notifyOnError) continue;
                String message = "Federation pull of " + registration.name + " @ " + registration.url + " is now at " + is.name();
                this.gitblit.sendMailToAdministrators("Pull Status of " + registration.name + " is " + is.name(), message);
            }
            catch (Throwable t) {
                this.logger.error(MessageFormat.format("Failed to pull from federated gitblit ({0} @ {1})", registration.name, registration.url), t);
            }
            finally {
                this.reschedule(registration);
            }
        }
    }

    private void pull(FederationModel registration) throws Exception {
        IUserService userService;
        File registrationFolderFile;
        block60: {
            Map<String, RepositoryModel> repositories = FederationUtils.getRepositories(registration, true);
            String registrationFolder = registration.folder.toLowerCase().trim();
            Character c = StringUtils.findInvalidCharacter(registrationFolder);
            if (c != null) {
                this.logger.error(MessageFormat.format("Illegal character ''{0}'' in folder name ''{1}'' of federation registration {2}!", c, registrationFolder, registration.name));
                return;
            }
            File repositoriesFolder = this.gitblit.getRepositoriesFolder();
            registrationFolderFile = new File(repositoriesFolder, registrationFolder);
            registrationFolderFile.mkdirs();
            for (Map.Entry<String, RepositoryModel> entry : repositories.entrySet()) {
                String cloneUrl = entry.getKey();
                RepositoryModel repositoryModel = entry.getValue();
                if (!repositoryModel.hasCommits) {
                    this.logger.warn(MessageFormat.format("Skipping federated repository {0} from {1} @ {2}. Repository is EMPTY.", repositoryModel.name, registration.name, registration.url));
                    registration.updateStatus(repositoryModel, Constants.FederationPullStatus.SKIPPED);
                    continue;
                }
                String repositoryName = StringUtils.isEmpty(registrationFolder) ? repositoryModel.name : registrationFolder + "/" + repositoryModel.name;
                if (registration.bare) {
                    if (!repositoryName.toLowerCase().endsWith(".git")) {
                        repositoryName = repositoryName + ".git";
                    }
                } else if (repositoryName.toLowerCase().endsWith(".git")) {
                    repositoryName = repositoryName.substring(0, repositoryName.indexOf(".git"));
                }
                String fetchHead = null;
                Repository existingRepository = this.gitblit.getRepository(repositoryName);
                if (existingRepository == null && this.gitblit.isCollectingGarbage(repositoryName)) {
                    this.logger.warn(MessageFormat.format("Skipping local repository {0}, busy collecting garbage", repositoryName));
                    continue;
                }
                if (existingRepository != null) {
                    StoredConfig storedConfig = existingRepository.getConfig();
                    storedConfig.load();
                    String origin = storedConfig.getString("remote", "origin", "url");
                    RevCommit commit = JGitUtils.getCommit(existingRepository, "FETCH_HEAD");
                    if (commit != null) {
                        fetchHead = commit.getName();
                    }
                    existingRepository.close();
                    if (!origin.startsWith(registration.url)) {
                        this.logger.warn(MessageFormat.format("Skipping federated repository {0} from {1} @ {2}. Origin does not match, consider EXCLUDING.", repositoryModel.name, registration.name, registration.url));
                        registration.updateStatus(repositoryModel, Constants.FederationPullStatus.SKIPPED);
                        continue;
                    }
                }
                UsernamePasswordCredentialsProvider usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider("$gitblit", registration.token);
                this.logger.info(MessageFormat.format("Pulling federated repository {0} from {1} @ {2}", repositoryModel.name, registration.name, registration.url));
                JGitUtils.CloneResult result = JGitUtils.cloneRepository(registrationFolderFile, repositoryModel.name, cloneUrl, registration.bare, (CredentialsProvider)usernamePasswordCredentialsProvider);
                Repository r = this.gitblit.getRepository(repositoryName);
                RepositoryModel rm = this.gitblit.getRepositoryModel(repositoryName);
                repositoryModel.isFrozen = registration.mirror;
                if (result.createdRepository) {
                    repositoryModel.federationStrategy = Constants.FederationStrategy.EXCLUDE;
                    repositoryModel.isFrozen = registration.mirror;
                    repositoryModel.showRemoteBranches = !registration.mirror;
                    this.logger.info(MessageFormat.format("     cloning {0}", repositoryModel.name));
                    registration.updateStatus(repositoryModel, Constants.FederationPullStatus.MIRRORED);
                } else {
                    boolean fetched = false;
                    RevCommit commit = JGitUtils.getCommit(r, "FETCH_HEAD");
                    String newFetchHead = commit.getName();
                    boolean bl = fetched = fetchHead == null || !fetchHead.equals(newFetchHead);
                    if (registration.mirror) {
                        if (fetched) {
                            for (RefModel ref : JGitUtils.getRemoteBranches(r, false, -1)) {
                                if (!ref.displayName.startsWith("origin/")) continue;
                                String branch = "refs/heads/" + ref.displayName.substring(ref.displayName.indexOf(47) + 1);
                                String hash = ref.getReferencedObjectId().getName();
                                JGitUtils.setBranchRef(r, branch, hash);
                                this.logger.info(MessageFormat.format("     resetting {0} of {1} to {2}", branch, repositoryModel.name, hash));
                            }
                            String newHead = StringUtils.isEmpty(repositoryModel.HEAD) ? newFetchHead : repositoryModel.HEAD;
                            JGitUtils.setHEADtoRef(r, newHead);
                            this.logger.info(MessageFormat.format("     resetting HEAD of {0} to {1}", repositoryModel.name, newHead));
                            registration.updateStatus(repositoryModel, Constants.FederationPullStatus.MIRRORED);
                        } else {
                            registration.updateStatus(repositoryModel, Constants.FederationPullStatus.NOCHANGE);
                        }
                    } else if (fetched) {
                        registration.updateStatus(repositoryModel, Constants.FederationPullStatus.PULLED);
                    } else {
                        registration.updateStatus(repositoryModel, Constants.FederationPullStatus.NOCHANGE);
                    }
                    repositoryModel.isFrozen = rm.isFrozen;
                    repositoryModel.federationStrategy = rm.federationStrategy;
                    HashSet<String> federationSets = new HashSet<String>();
                    if (rm.federationSets != null) {
                        federationSets.addAll(rm.federationSets);
                    }
                    if (repositoryModel.federationSets != null) {
                        federationSets.addAll(repositoryModel.federationSets);
                    }
                    repositoryModel.federationSets = new ArrayList<String>(federationSets);
                    HashSet<String> indexedBranches = new HashSet<String>();
                    if (rm.indexedBranches != null) {
                        indexedBranches.addAll(rm.indexedBranches);
                    }
                    if (repositoryModel.indexedBranches != null) {
                        indexedBranches.addAll(repositoryModel.indexedBranches);
                    }
                    repositoryModel.indexedBranches = new ArrayList<String>(indexedBranches);
                }
                repositoryModel.isFederated = cloneUrl.startsWith(registration.url);
                this.gitblit.updateConfiguration(r, repositoryModel);
                r.close();
            }
            userService = null;
            try {
                List<UserModel> users = FederationUtils.getUsers(registration);
                if (users == null || users.size() <= 0) break block60;
                File realmFile = new File(registrationFolderFile, registration.name + "_users.conf");
                realmFile.delete();
                userService = new ConfigUserService(realmFile);
                for (UserModel user : users) {
                    UserModel localUser;
                    userService.updateUserModel(user.username, user);
                    if (!registration.mergeAccounts) continue;
                    if (!StringUtils.isEmpty(registrationFolder)) {
                        if (user.permissions != null) {
                            HashMap<String, Constants.AccessPermission> copy = new HashMap<String, Constants.AccessPermission>(user.permissions);
                            user.permissions.clear();
                            for (Map.Entry entry : copy.entrySet()) {
                                user.setRepositoryPermission(registrationFolder + "/" + (String)entry.getKey(), (Constants.AccessPermission)((Object)entry.getValue()));
                            }
                        } else {
                            ArrayList<String> permissions = new ArrayList<String>(user.repositories);
                            user.repositories.clear();
                            for (String string : permissions) {
                                user.addRepositoryPermission(registrationFolder + "/" + string);
                            }
                        }
                    }
                    if ((localUser = this.gitblit.getUserModel(user.username)) == null) {
                        this.gitblit.addUser(user);
                    } else {
                        if (user.permissions != null) {
                            HashMap<String, Constants.AccessPermission> copy = new HashMap<String, Constants.AccessPermission>(user.permissions);
                            for (Map.Entry entry : copy.entrySet()) {
                                localUser.setRepositoryPermission((String)entry.getKey(), (Constants.AccessPermission)((Object)entry.getValue()));
                            }
                        } else {
                            for (String string : user.repositories) {
                                localUser.addRepositoryPermission(string);
                            }
                        }
                        localUser.password = user.password;
                        localUser.canAdmin = user.canAdmin;
                        this.gitblit.reviseUser(localUser.username, localUser);
                    }
                    for (String string : this.gitblit.getAllTeamNames()) {
                        TeamModel remoteTeam;
                        TeamModel team = this.gitblit.getTeamModel(string);
                        if (user.isTeamMember(string) && !team.hasUser(user.username)) {
                            team.addUser(user.username);
                            this.gitblit.updateTeamModel(string, team);
                        } else if (!user.isTeamMember(string) && team.hasUser(user.username)) {
                            team.removeUser(user.username);
                            this.gitblit.updateTeamModel(string, team);
                        }
                        if ((remoteTeam = user.getTeam(string)) == null) continue;
                        if (remoteTeam.permissions != null) {
                            for (Map.Entry<String, Constants.AccessPermission> entry : remoteTeam.permissions.entrySet()) {
                                team.setRepositoryPermission(entry.getKey(), entry.getValue());
                            }
                            this.gitblit.updateTeamModel(string, team);
                            continue;
                        }
                        if (ArrayUtils.isEmpty(remoteTeam.repositories)) continue;
                        team.addRepositoryPermissions(remoteTeam.repositories);
                        this.gitblit.updateTeamModel(string, team);
                    }
                }
            }
            catch (GitBlitException.ForbiddenException users) {
            }
            catch (IOException e) {
                this.logger.warn(MessageFormat.format("Failed to retrieve USERS from federated gitblit ({0} @ {1})", registration.name, registration.url), (Throwable)e);
            }
        }
        try {
            List<TeamModel> teams;
            if (userService != null && (teams = FederationUtils.getTeams(registration)) != null && teams.size() > 0) {
                for (TeamModel teamModel : teams) {
                    userService.updateTeamModel(teamModel);
                }
            }
        }
        catch (GitBlitException.ForbiddenException teams) {
        }
        catch (IOException e) {
            this.logger.warn(MessageFormat.format("Failed to retrieve TEAMS from federated gitblit ({0} @ {1})", registration.name, registration.url), (Throwable)e);
        }
        try {
            Map<String, String> settings = FederationUtils.getSettings(registration);
            if (settings != null && settings.size() > 0) {
                Properties properties = new Properties();
                properties.putAll(settings);
                FileOutputStream fileOutputStream = new FileOutputStream(new File(registrationFolderFile, registration.name + "_" + "gitblit.properties"));
                properties.store(fileOutputStream, null);
                fileOutputStream.close();
            }
        }
        catch (GitBlitException.ForbiddenException settings) {
        }
        catch (IOException e) {
            this.logger.warn(MessageFormat.format("Failed to retrieve SETTINGS from federated gitblit ({0} @ {1})", registration.name, registration.url), (Throwable)e);
        }
        try {
            Map<String, String> scripts = FederationUtils.getScripts(registration);
            if (scripts != null && scripts.size() > 0) {
                for (Map.Entry entry : scripts.entrySet()) {
                    String scriptName = (String)entry.getKey();
                    if (scriptName.endsWith(".groovy")) {
                        scriptName = scriptName.substring(0, scriptName.indexOf(".groovy"));
                    }
                    File file = new File(registrationFolderFile, registration.name + "_" + scriptName + ".groovy");
                    FileUtils.writeContent(file, (String)entry.getValue());
                }
            }
        }
        catch (GitBlitException.ForbiddenException scripts) {
        }
        catch (IOException e) {
            this.logger.warn(MessageFormat.format("Failed to retrieve SCRIPTS from federated gitblit ({0} @ {1})", registration.name, registration.url), (Throwable)e);
        }
    }

    private void sendStatusAcknowledgment(FederationModel registration) throws Exception {
        if (!registration.sendStatus) {
            return;
        }
        InetAddress addr = InetAddress.getLocalHost();
        String federationName = this.gitblit.getSettings().getString("federation.name", null);
        if (StringUtils.isEmpty(federationName)) {
            federationName = addr.getHostName();
        }
        FederationUtils.acknowledgeStatus(addr.getHostAddress(), registration);
        this.logger.info(MessageFormat.format("Pull status sent to {0}", registration.url));
    }
}

