/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.service;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.models.PathModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.SearchResult;
import com.gitblit.service.LuceneRepoIndexStore;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneService
implements Runnable {
    private static final int INDEX_VERSION = 6;
    private static final String FIELD_OBJECT_TYPE = "type";
    private static final String FIELD_PATH = "path";
    private static final String FIELD_COMMIT = "commit";
    private static final String FIELD_BRANCH = "branch";
    private static final String FIELD_SUMMARY = "summary";
    private static final String FIELD_CONTENT = "content";
    private static final String FIELD_AUTHOR = "author";
    private static final String FIELD_COMMITTER = "committer";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_TAG = "tag";
    private static final String CONF_ALIAS = "aliases";
    private static final String CONF_BRANCH = "branches";
    private final Logger logger = LoggerFactory.getLogger(LuceneService.class);
    private final IStoredSettings storedSettings;
    private final IRepositoryManager repositoryManager;
    private final File repositoriesFolder;
    private final Map<String, IndexSearcher> searchers = new ConcurrentHashMap<String, IndexSearcher>();
    private final Map<String, IndexWriter> writers = new ConcurrentHashMap<String, IndexWriter>();
    private final String luceneIgnoreExtensions = "7z arc arj bin bmp dll doc docx exe gif gz jar jpg lib lzh odg odf odt pdf ppt png so swf xcf xls xlsx zip";
    private Set<String> excludedExtensions;

    public LuceneService(IStoredSettings settings, IRepositoryManager repositoryManager) {
        this.storedSettings = settings;
        this.repositoryManager = repositoryManager;
        this.repositoriesFolder = repositoryManager.getRepositoriesFolder();
        String exts = "7z arc arj bin bmp dll doc docx exe gif gz jar jpg lib lzh odg odf odt pdf ppt png so swf xcf xls xlsx zip";
        if (settings != null) {
            exts = settings.getString("web.luceneIgnoreExtensions", exts);
        }
        this.excludedExtensions = new TreeSet<String>(StringUtils.getStringsFromValue(exts));
    }

    @Override
    public void run() {
        if (!this.storedSettings.getBoolean("web.allowLuceneIndexing", true)) {
            return;
        }
        String exts = this.storedSettings.getString("web.luceneIgnoreExtensions", "7z arc arj bin bmp dll doc docx exe gif gz jar jpg lib lzh odg odf odt pdf ppt png so swf xcf xls xlsx zip");
        this.excludedExtensions = new TreeSet<String>(StringUtils.getStringsFromValue(exts));
        if (this.repositoryManager.isCollectingGarbage()) {
            return;
        }
        for (String repositoryName : this.repositoryManager.getRepositoryList()) {
            RepositoryModel model = this.repositoryManager.getRepositoryModel(repositoryName);
            if (!model.hasCommits || ArrayUtils.isEmpty(model.indexedBranches)) continue;
            Repository repository = this.repositoryManager.getRepository(model.name);
            if (repository == null) {
                if (!this.repositoryManager.isCollectingGarbage(model.name)) continue;
                this.logger.info(MessageFormat.format("Skipping Lucene index of {0}, busy garbage collecting", repositoryName));
                continue;
            }
            this.index(model, repository);
            repository.close();
            System.gc();
        }
    }

    private void index(RepositoryModel model, Repository repository) {
        try {
            if (this.shouldReindex(repository)) {
                IndexResult result = this.reindex(model, repository);
                if (result.success) {
                    if (result.commitCount > 0) {
                        String msg = "Built {0} Lucene index from {1} commits and {2} files across {3} branches in {4} secs";
                        this.logger.info(MessageFormat.format(msg, model.name, result.commitCount, result.blobCount, result.branchCount, Float.valueOf(result.duration())));
                    }
                } else {
                    String msg = "Could not build {0} Lucene index!";
                    this.logger.error(MessageFormat.format(msg, model.name));
                }
            } else {
                IndexResult result = this.updateIndex(model, repository);
                if (result.success) {
                    if (result.commitCount > 0) {
                        String msg = "Updated {0} Lucene index with {1} commits and {2} files across {3} branches in {4} secs";
                        this.logger.info(MessageFormat.format(msg, model.name, result.commitCount, result.blobCount, result.branchCount, Float.valueOf(result.duration())));
                    }
                } else {
                    String msg = "Could not update {0} Lucene index!";
                    this.logger.error(MessageFormat.format(msg, model.name));
                }
            }
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Lucene indexing failure for {0}", model.name), t);
        }
    }

    public synchronized void close(String repositoryName) {
        try {
            IndexSearcher searcher = this.searchers.remove(repositoryName);
            if (searcher != null) {
                searcher.getIndexReader().close();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to close index searcher for " + repositoryName, (Throwable)e);
        }
        try {
            IndexWriter writer = this.writers.remove(repositoryName);
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to close index writer for " + repositoryName, (Throwable)e);
        }
    }

    public synchronized void close() {
        for (String writer : this.writers.keySet()) {
            try {
                this.writers.get(writer).close();
            }
            catch (Throwable t) {
                this.logger.error("Failed to close Lucene writer for " + writer, t);
            }
        }
        this.writers.clear();
        for (String searcher : this.searchers.keySet()) {
            try {
                this.searchers.get(searcher).getIndexReader().close();
            }
            catch (Throwable t) {
                this.logger.error("Failed to close Lucene searcher for " + searcher, t);
            }
        }
        this.searchers.clear();
    }

    public boolean deleteIndex(String repositoryName) {
        this.close(repositoryName);
        File repositoryFolder = RepositoryCache.FileKey.resolve((File)new File(this.repositoriesFolder, repositoryName), (FS)FS.DETECTED);
        LuceneRepoIndexStore luceneIndex = new LuceneRepoIndexStore(repositoryFolder, 6);
        return luceneIndex.delete();
    }

    private String getAuthor(RevCommit commit) {
        String name = "unknown";
        try {
            name = commit.getAuthorIdent().getName();
            if (StringUtils.isEmpty(name)) {
                name = commit.getAuthorIdent().getEmailAddress();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return name;
    }

    private String getCommitter(RevCommit commit) {
        String name = "unknown";
        try {
            name = commit.getCommitterIdent().getName();
            if (StringUtils.isEmpty(name)) {
                name = commit.getCommitterIdent().getEmailAddress();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return name;
    }

    private RevTree getTree(RevWalk walk, RevCommit commit) throws IOException {
        RevTree tree = commit.getTree();
        if (tree != null) {
            return tree;
        }
        walk.parseHeaders((RevObject)commit);
        return commit.getTree();
    }

    private String getBranchKey(String branchName) {
        return StringUtils.getSHA1(branchName);
    }

    private FileBasedConfig getConfig(Repository repository) {
        LuceneRepoIndexStore luceneIndex = new LuceneRepoIndexStore(repository.getDirectory(), 6);
        FileBasedConfig config = new FileBasedConfig(luceneIndex.getConfigFile(), FS.detect());
        return config;
    }

    private boolean shouldReindex(Repository repository) {
        return !new LuceneRepoIndexStore(repository.getDirectory(), 6).hasIndex();
    }

    public IndexResult reindex(RepositoryModel model, Repository repository) {
        IndexResult result = new IndexResult();
        if (!this.deleteIndex(model.name)) {
            return result;
        }
        try {
            String[] encodings = this.storedSettings.getStrings("web.blobEncodings").toArray(new String[0]);
            FileBasedConfig config = this.getConfig(repository);
            TreeSet<String> indexedCommits = new TreeSet<String>();
            IndexWriter writer = this.getIndexWriter(model.name);
            HashMap tags = new HashMap();
            for (RefModel tag : JGitUtils.getTags(repository, false, -1)) {
                if (!tag.isAnnotatedTag()) continue;
                if (!tags.containsKey(tag.getReferencedObjectId().getName())) {
                    tags.put(tag.getReferencedObjectId().getName(), new ArrayList());
                }
                ((List)tags.get(tag.getReferencedObjectId().getName())).add(tag.displayName);
            }
            ObjectReader reader = repository.newObjectReader();
            List<RefModel> branches = JGitUtils.getLocalBranches(repository, true, -1);
            Collections.sort(branches, new Comparator<RefModel>(){

                @Override
                public int compare(RefModel ref1, RefModel ref2) {
                    return ref2.getDate().compareTo(ref1.getDate());
                }
            });
            RefModel defaultBranch = null;
            ObjectId defaultBranchId = JGitUtils.getDefaultBranch(repository);
            for (RefModel branch : branches) {
                if (!branch.getObjectId().equals((AnyObjectId)defaultBranchId)) continue;
                defaultBranch = branch;
                break;
            }
            branches.remove(defaultBranch);
            branches.add(0, defaultBranch);
            for (RefModel branch : branches) {
                RevCommit rev;
                RevCommit commit;
                boolean indexBranch = false;
                indexBranch = model.indexedBranches.contains("default") && branch.equals(defaultBranch) ? true : (branch.getName().startsWith("refs/meta/") ? false : model.indexedBranches.contains(branch.getName()));
                if (!indexBranch) continue;
                String branchName = branch.getName();
                RevWalk revWalk = new RevWalk(reader);
                RevCommit tip = revWalk.parseCommit((AnyObjectId)branch.getObjectId());
                String tipId = tip.getId().getName();
                String keyName = this.getBranchKey(branchName);
                config.setString(CONF_ALIAS, null, keyName, branchName);
                config.setString(CONF_BRANCH, null, keyName, tipId);
                TreeWalk treeWalk = new TreeWalk(repository);
                treeWalk.addTree((AnyObjectId)tip.getTree());
                treeWalk.setRecursive(true);
                TreeMap<String, ObjectId> paths = new TreeMap<String, ObjectId>();
                while (treeWalk.next()) {
                    if (treeWalk.getFileMode(0) == FileMode.GITLINK) continue;
                    paths.put(treeWalk.getPathString(), treeWalk.getObjectId(0));
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] tmp = new byte[Short.MAX_VALUE];
                RevWalk commitWalk = new RevWalk(reader);
                commitWalk.markStart(tip);
                block10: while (paths.size() > 0 && (commit = commitWalk.next()) != null) {
                    TreeWalk diffWalk = new TreeWalk(reader);
                    int parentCount = commit.getParentCount();
                    switch (parentCount) {
                        case 0: {
                            diffWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                            break;
                        }
                        case 1: {
                            diffWalk.addTree((AnyObjectId)this.getTree(commitWalk, commit.getParent(0)));
                            break;
                        }
                        default: {
                            continue block10;
                        }
                    }
                    diffWalk.addTree((AnyObjectId)this.getTree(commitWalk, commit));
                    diffWalk.setFilter(TreeFilter.ANY_DIFF);
                    diffWalk.setRecursive(true);
                    while (paths.size() > 0 && diffWalk.next()) {
                        String path = diffWalk.getPathString();
                        if (!paths.containsKey(path)) continue;
                        ObjectId blobId = (ObjectId)paths.remove(path);
                        ++result.blobCount;
                        String blobAuthor = this.getAuthor(commit);
                        String blobCommitter = this.getCommitter(commit);
                        String blobDate = DateTools.timeToString((long)((long)commit.getCommitTime() * 1000L), (DateTools.Resolution)DateTools.Resolution.MINUTE);
                        Document doc = new Document();
                        doc.add((IndexableField)new Field(FIELD_OBJECT_TYPE, Constants.SearchObjectType.blob.name(), StringField.TYPE_STORED));
                        doc.add((IndexableField)new Field(FIELD_BRANCH, branchName, TextField.TYPE_STORED));
                        doc.add((IndexableField)new Field(FIELD_COMMIT, commit.getName(), TextField.TYPE_STORED));
                        doc.add((IndexableField)new Field(FIELD_PATH, path, TextField.TYPE_STORED));
                        doc.add((IndexableField)new Field(FIELD_DATE, blobDate, StringField.TYPE_STORED));
                        doc.add((IndexableField)new Field(FIELD_AUTHOR, blobAuthor, TextField.TYPE_STORED));
                        doc.add((IndexableField)new Field(FIELD_COMMITTER, blobCommitter, TextField.TYPE_STORED));
                        String ext = null;
                        String name = path.toLowerCase();
                        if (name.indexOf(46) > -1) {
                            ext = name.substring(name.lastIndexOf(46) + 1);
                        }
                        if (StringUtils.isEmpty(ext) || !this.excludedExtensions.contains(ext)) {
                            int n;
                            ObjectLoader ldr = repository.open((AnyObjectId)blobId, 3);
                            ObjectStream in = ldr.openStream();
                            while ((n = in.read(tmp)) > 0) {
                                os.write(tmp, 0, n);
                            }
                            in.close();
                            byte[] content = os.toByteArray();
                            String str = StringUtils.decodeString(content, encodings);
                            doc.add((IndexableField)new Field(FIELD_CONTENT, str, TextField.TYPE_STORED));
                            os.reset();
                        }
                        writer.addDocument((Iterable)doc);
                    }
                }
                os.close();
                if (indexedCommits.add(tipId)) {
                    Document doc = this.createDocument(tip, (List)tags.get(tipId));
                    doc.add((IndexableField)new Field(FIELD_BRANCH, branchName, TextField.TYPE_STORED));
                    writer.addDocument((Iterable)doc);
                    ++result.commitCount;
                    ++result.branchCount;
                }
                RevWalk historyWalk = new RevWalk(reader);
                historyWalk.markStart(historyWalk.parseCommit((AnyObjectId)tip.getId()));
                while ((rev = historyWalk.next()) != null) {
                    String hash = rev.getId().getName();
                    if (!indexedCommits.add(hash)) continue;
                    Document doc = this.createDocument(rev, (List)tags.get(hash));
                    doc.add((IndexableField)new Field(FIELD_BRANCH, branchName, TextField.TYPE_STORED));
                    writer.addDocument((Iterable)doc);
                    ++result.commitCount;
                }
            }
            reader.close();
            config.save();
            writer.commit();
            this.resetIndexSearcher(model.name);
            result.success();
        }
        catch (Exception e) {
            this.logger.error("Exception while reindexing " + model.name, (Throwable)e);
        }
        return result;
    }

    private IndexResult index(String repositoryName, Repository repository, String branch, RevCommit commit) {
        IndexResult result = new IndexResult();
        try {
            String[] encodings = this.storedSettings.getStrings("web.blobEncodings").toArray(new String[0]);
            List<PathModel.PathChangeModel> changedPaths = JGitUtils.getFilesInCommit(repository, commit);
            String revDate = DateTools.timeToString((long)((long)commit.getCommitTime() * 1000L), (DateTools.Resolution)DateTools.Resolution.MINUTE);
            IndexWriter writer = this.getIndexWriter(repositoryName);
            for (PathModel.PathChangeModel path : changedPaths) {
                String str;
                if (path.isSubmodule()) continue;
                this.deleteBlob(repositoryName, branch, path.name);
                if (DiffEntry.ChangeType.DELETE.equals((Object)path.changeType)) continue;
                ++result.blobCount;
                Document doc = new Document();
                doc.add((IndexableField)new Field(FIELD_OBJECT_TYPE, Constants.SearchObjectType.blob.name(), StringField.TYPE_STORED));
                doc.add((IndexableField)new Field(FIELD_BRANCH, branch, TextField.TYPE_STORED));
                doc.add((IndexableField)new Field(FIELD_COMMIT, commit.getName(), TextField.TYPE_STORED));
                doc.add((IndexableField)new Field(FIELD_PATH, path.path, TextField.TYPE_STORED));
                doc.add((IndexableField)new Field(FIELD_DATE, revDate, StringField.TYPE_STORED));
                doc.add((IndexableField)new Field(FIELD_AUTHOR, this.getAuthor(commit), TextField.TYPE_STORED));
                doc.add((IndexableField)new Field(FIELD_COMMITTER, this.getCommitter(commit), TextField.TYPE_STORED));
                String ext = null;
                String name = path.name.toLowerCase();
                if (name.indexOf(46) > -1) {
                    ext = name.substring(name.lastIndexOf(46) + 1);
                }
                if (!StringUtils.isEmpty(ext) && this.excludedExtensions.contains(ext) || (str = JGitUtils.getStringContent(repository, commit.getTree(), path.path, encodings)) == null) continue;
                doc.add((IndexableField)new Field(FIELD_CONTENT, str, TextField.TYPE_STORED));
                writer.addDocument((Iterable)doc);
            }
            writer.commit();
            ArrayList<String> commitTags = new ArrayList<String>();
            for (RefModel ref : JGitUtils.getTags(repository, false, -1)) {
                if (!ref.isAnnotatedTag() || !ref.getReferencedObjectId().equals((AnyObjectId)commit.getId())) continue;
                commitTags.add(ref.displayName);
            }
            Document doc = this.createDocument(commit, commitTags);
            doc.add((IndexableField)new Field(FIELD_BRANCH, branch, TextField.TYPE_STORED));
            ++result.commitCount;
            result.success = this.index(repositoryName, doc);
        }
        catch (Exception e) {
            this.logger.error(MessageFormat.format("Exception while indexing commit {0} in {1}", commit.getId().getName(), repositoryName), (Throwable)e);
        }
        return result;
    }

    public boolean deleteBlob(String repositoryName, String branch, String path) throws Exception {
        String pattern = MessageFormat.format("{0}:'{'0} AND {1}:\"'{'1'}'\" AND {2}:\"'{'2'}'\"", FIELD_OBJECT_TYPE, FIELD_BRANCH, FIELD_PATH);
        String q = MessageFormat.format(pattern, Constants.SearchObjectType.blob.name(), branch, path);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        QueryParser qp = new QueryParser(FIELD_SUMMARY, (Analyzer)analyzer);
        BooleanQuery query = new BooleanQuery.Builder().add(qp.parse(q), BooleanClause.Occur.MUST).build();
        IndexWriter writer = this.getIndexWriter(repositoryName);
        int numDocsBefore = writer.numDocs();
        writer.deleteDocuments(new Query[]{query});
        writer.commit();
        int numDocsAfter = writer.numDocs();
        if (numDocsBefore == numDocsAfter) {
            this.logger.debug(MessageFormat.format("no records found to delete {0}", query.toString()));
            return false;
        }
        this.logger.debug(MessageFormat.format("deleted {0} records with {1}", numDocsBefore - numDocsAfter, query.toString()));
        return true;
    }

    private IndexResult updateIndex(RepositoryModel model, Repository repository) {
        IndexResult result = new IndexResult();
        try {
            FileBasedConfig config = this.getConfig(repository);
            config.load();
            HashMap tags = new HashMap();
            for (RefModel tag : JGitUtils.getTags(repository, false, -1)) {
                if (!tag.isAnnotatedTag()) continue;
                if (!tags.containsKey(tag.getObjectId().getName())) {
                    tags.put(tag.getReferencedObjectId().getName(), new ArrayList());
                }
                ((List)tags.get(tag.getReferencedObjectId().getName())).add(tag.displayName);
            }
            TreeSet<String> deletedBranches = new TreeSet<String>();
            for (String alias : config.getNames(CONF_ALIAS)) {
                String branch = config.getString(CONF_ALIAS, null, alias);
                deletedBranches.add(branch);
            }
            List<RefModel> branches = JGitUtils.getLocalBranches(repository, true, -1);
            Collections.sort(branches, new Comparator<RefModel>(){

                @Override
                public int compare(RefModel ref1, RefModel ref2) {
                    return ref2.getDate().compareTo(ref1.getDate());
                }
            });
            RefModel defaultBranch = null;
            ObjectId defaultBranchId = JGitUtils.getDefaultBranch(repository);
            for (RefModel refModel : branches) {
                if (!refModel.getObjectId().equals((AnyObjectId)defaultBranchId)) continue;
                defaultBranch = refModel;
                break;
            }
            branches.remove(defaultBranch);
            branches.add(0, defaultBranch);
            for (RefModel refModel : branches) {
                String branchName = refModel.getName();
                boolean indexBranch = false;
                indexBranch = model.indexedBranches.contains("default") && refModel.equals(defaultBranch) ? true : (refModel.getName().startsWith("refs/meta/") ? false : model.indexedBranches.contains(refModel.getName()));
                if (!indexBranch) continue;
                deletedBranches.remove(branchName);
                String keyName = this.getBranchKey(branchName);
                String lastCommit = config.getString(CONF_BRANCH, null, keyName);
                List<RevCommit> revs = StringUtils.isEmpty(lastCommit) ? JGitUtils.getRevLog(repository, branchName, 0, -1) : JGitUtils.getRevLog(repository, lastCommit, branchName);
                if (revs.size() > 0) {
                    ++result.branchCount;
                }
                Collections.reverse(revs);
                for (RevCommit commit : revs) {
                    result.add(this.index(model.name, repository, branchName, commit));
                }
                config.setString(CONF_ALIAS, null, keyName, branchName);
                config.setString(CONF_BRANCH, null, keyName, refModel.getObjectId().getName());
                config.save();
            }
            if (deletedBranches.size() > 0) {
                for (String string : deletedBranches) {
                    IndexWriter writer = this.getIndexWriter(model.name);
                    writer.deleteDocuments(new Term[]{new Term(FIELD_BRANCH, string)});
                    writer.commit();
                }
            }
            result.success = true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Exception while updating {0} Lucene index", model.name), t);
        }
        return result;
    }

    private Document createDocument(RevCommit commit, List<String> tags) {
        Document doc = new Document();
        doc.add((IndexableField)new Field(FIELD_OBJECT_TYPE, Constants.SearchObjectType.commit.name(), StringField.TYPE_STORED));
        doc.add((IndexableField)new Field(FIELD_COMMIT, commit.getName(), TextField.TYPE_STORED));
        doc.add((IndexableField)new Field(FIELD_DATE, DateTools.timeToString((long)((long)commit.getCommitTime() * 1000L), (DateTools.Resolution)DateTools.Resolution.MINUTE), StringField.TYPE_STORED));
        doc.add((IndexableField)new Field(FIELD_AUTHOR, this.getAuthor(commit), TextField.TYPE_STORED));
        doc.add((IndexableField)new Field(FIELD_COMMITTER, this.getCommitter(commit), TextField.TYPE_STORED));
        doc.add((IndexableField)new Field(FIELD_SUMMARY, commit.getShortMessage(), TextField.TYPE_STORED));
        doc.add((IndexableField)new Field(FIELD_CONTENT, commit.getFullMessage(), TextField.TYPE_STORED));
        if (!ArrayUtils.isEmpty(tags)) {
            doc.add((IndexableField)new Field(FIELD_TAG, StringUtils.flattenStrings(tags), TextField.TYPE_STORED));
        }
        return doc;
    }

    private boolean index(String repositoryName, Document doc) {
        try {
            IndexWriter writer = this.getIndexWriter(repositoryName);
            writer.addDocument((Iterable)doc);
            writer.commit();
            this.resetIndexSearcher(repositoryName);
            return true;
        }
        catch (Exception e) {
            this.logger.error(MessageFormat.format("Exception while incrementally updating {0} Lucene index", repositoryName), (Throwable)e);
            return false;
        }
    }

    private SearchResult createSearchResult(Document doc, float score, int hitId, int totalHits) throws ParseException {
        SearchResult result = new SearchResult();
        result.hitId = hitId;
        result.totalHits = totalHits;
        result.score = score;
        result.date = DateTools.stringToDate((String)doc.get(FIELD_DATE));
        result.summary = doc.get(FIELD_SUMMARY);
        result.author = doc.get(FIELD_AUTHOR);
        result.committer = doc.get(FIELD_COMMITTER);
        result.type = Constants.SearchObjectType.fromName(doc.get(FIELD_OBJECT_TYPE));
        result.branch = doc.get(FIELD_BRANCH);
        result.commitId = doc.get(FIELD_COMMIT);
        result.path = doc.get(FIELD_PATH);
        if (doc.get(FIELD_TAG) != null) {
            result.tags = StringUtils.getStringsFromValue(doc.get(FIELD_TAG));
        }
        return result;
    }

    private synchronized void resetIndexSearcher(String repository) throws IOException {
        IndexSearcher searcher = this.searchers.remove(repository);
        if (searcher != null) {
            searcher.getIndexReader().close();
        }
    }

    private IndexSearcher getIndexSearcher(String repository) throws IOException {
        IndexSearcher searcher = this.searchers.get(repository);
        if (searcher == null) {
            IndexWriter writer = this.getIndexWriter(repository);
            searcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)writer, (boolean)true));
            this.searchers.put(repository, searcher);
        }
        return searcher;
    }

    private IndexWriter getIndexWriter(String repository) throws IOException {
        IndexWriter indexWriter = this.writers.get(repository);
        if (indexWriter == null) {
            File repositoryFolder = RepositoryCache.FileKey.resolve((File)new File(this.repositoriesFolder, repository), (FS)FS.DETECTED);
            LuceneRepoIndexStore indexStore = new LuceneRepoIndexStore(repositoryFolder, 6);
            indexStore.create();
            FSDirectory directory = FSDirectory.open((Path)indexStore.getPath());
            StandardAnalyzer analyzer = new StandardAnalyzer();
            IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            indexWriter = new IndexWriter((Directory)directory, config);
            this.writers.put(repository, indexWriter);
        }
        return indexWriter;
    }

    public List<SearchResult> search(String text, int page, int pageSize, List<String> repositories) {
        if (ArrayUtils.isEmpty(repositories)) {
            return null;
        }
        return this.search(text, page, pageSize, repositories.toArray(new String[0]));
    }

    public List<SearchResult> search(String text, int page, int pageSize, String ... repositories) {
        if (StringUtils.isEmpty(text)) {
            return null;
        }
        if (ArrayUtils.isEmpty(repositories)) {
            return null;
        }
        LinkedHashSet<SearchResult> results = new LinkedHashSet<SearchResult>();
        StandardAnalyzer analyzer = new StandardAnalyzer();
        try {
            IndexSearcher searcher;
            BooleanQuery.Builder bldr = new BooleanQuery.Builder();
            QueryParser qp = new QueryParser(FIELD_SUMMARY, (Analyzer)analyzer);
            qp.setAllowLeadingWildcard(true);
            bldr.add(qp.parse(text), BooleanClause.Occur.SHOULD);
            qp = new QueryParser(FIELD_CONTENT, (Analyzer)analyzer);
            qp.setAllowLeadingWildcard(true);
            bldr.add(qp.parse(text), BooleanClause.Occur.SHOULD);
            if (repositories.length == 1) {
                searcher = this.getIndexSearcher(repositories[0]);
            } else {
                ArrayList<IndexReader> readers = new ArrayList<IndexReader>();
                for (String repository : repositories) {
                    IndexSearcher repositoryIndex = this.getIndexSearcher(repository);
                    readers.add(repositoryIndex.getIndexReader());
                }
                IndexReader[] rdrs = readers.toArray(new IndexReader[readers.size()]);
                MultiSourceReader reader = new MultiSourceReader(rdrs);
                searcher = new IndexSearcher((IndexReader)reader);
            }
            BooleanQuery query = bldr.build();
            Query rewrittenQuery = searcher.rewrite((Query)query);
            this.logger.debug(rewrittenQuery.toString());
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)5000);
            searcher.search(rewrittenQuery, (Collector)collector);
            int offset = Math.max(0, (page - 1) * pageSize);
            ScoreDoc[] hits = collector.topDocs((int)offset, (int)pageSize).scoreDocs;
            int totalHits = collector.getTotalHits();
            for (int i = 0; i < hits.length; ++i) {
                int docId = hits[i].doc;
                Document doc = searcher.doc(docId);
                SearchResult result = this.createSearchResult(doc, hits[i].score, offset + i + 1, totalHits);
                if (repositories.length == 1) {
                    result.repository = repositories[0];
                } else {
                    MultiSourceReader reader = (MultiSourceReader)searcher.getIndexReader();
                    int index = reader.getSourceIndex(docId);
                    result.repository = repositories[index];
                }
                String content = doc.get(FIELD_CONTENT);
                result.fragment = this.getHighlightedFragment((Analyzer)analyzer, (Query)query, content, result);
                results.add(result);
            }
        }
        catch (Exception e) {
            this.logger.error(MessageFormat.format("Exception while searching for {0}", text), (Throwable)e);
        }
        return new ArrayList<SearchResult>(results);
    }

    private String getHighlightedFragment(Analyzer analyzer, Query query, String content, SearchResult result) throws IOException, InvalidTokenOffsetsException {
        if (content == null) {
            content = "";
        }
        int tabLength = this.storedSettings.getInteger("web.tabLength", 4);
        int fragmentLength = Constants.SearchObjectType.commit == result.type ? 512 : 150;
        QueryScorer scorer = new QueryScorer(query, FIELD_CONTENT);
        SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(scorer, fragmentLength);
        String termTag = "!!--[";
        String termTagEnd = "]--!!";
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(termTag, termTagEnd);
        Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)scorer);
        highlighter.setTextFragmenter((Fragmenter)fragmenter);
        Object[] fragments = highlighter.getBestFragments(analyzer, FIELD_CONTENT, content, 3);
        if (ArrayUtils.isEmpty(fragments)) {
            if (Constants.SearchObjectType.blob == result.type) {
                return "";
            }
            String fragment = content;
            if (fragment.length() > fragmentLength) {
                fragment = fragment.substring(0, fragmentLength) + "...";
            }
            return "<pre class=\"text\">" + StringUtils.escapeForHtml(fragment, true, tabLength) + "</pre>";
        }
        LinkedHashSet<Object> uniqueFragments = new LinkedHashSet<Object>();
        for (Object fragment : fragments) {
            uniqueFragments.add(fragment);
        }
        fragments = uniqueFragments.toArray(new String[uniqueFragments.size()]);
        StringBuilder sb = new StringBuilder();
        int len = fragments.length;
        for (int i = 0; i < len; ++i) {
            int pos;
            Object fragment;
            fragment = fragments[i];
            String tag = "<pre class=\"text\">";
            String raw = ((String)fragment).replace(termTag, "").replace(termTagEnd, "");
            int c = pos = content.indexOf(raw);
            while (c > 0 && content.charAt(--c) != '\n') {
            }
            if (c > 0) {
                fragment = content.substring(c + 1, pos) + (String)fragment;
            }
            if (Constants.SearchObjectType.blob == result.type) {
                int line = Math.max(1, StringUtils.countLines(content.substring(0, pos)));
                String lang = "";
                String ext = StringUtils.getFileExtension(result.path).toLowerCase();
                if (!StringUtils.isEmpty(ext)) {
                    lang = " lang-" + ext;
                }
                tag = MessageFormat.format("<pre class=\"prettyprint linenums:{0,number,0}{1}\">", line, lang);
            }
            sb.append(tag);
            String html = StringUtils.escapeForHtml((String)fragment, false);
            html = html.replace(termTag, "<span class=\"highlight\">").replace(termTagEnd, "</span>");
            sb.append(html);
            sb.append("</pre>");
            if (i >= len - 1) continue;
            sb.append("<span class=\"ellipses\">...</span><br/>");
        }
        return sb.toString();
    }

    private class MultiSourceReader
    extends MultiReader {
        MultiSourceReader(IndexReader[] readers) throws IOException {
            super(readers, false);
        }

        int getSourceIndex(int docId) {
            int index = -1;
            try {
                index = super.readerIndex(docId);
            }
            catch (Exception e) {
                LuceneService.this.logger.error("Error getting source index", (Throwable)e);
            }
            return index;
        }
    }

    private class IndexResult {
        long startTime;
        long endTime;
        boolean success;
        int branchCount;
        int commitCount;
        int blobCount;

        private IndexResult() {
            this.endTime = this.startTime = System.currentTimeMillis();
        }

        void add(IndexResult result) {
            this.branchCount += result.branchCount;
            this.commitCount += result.commitCount;
            this.blobCount += result.blobCount;
        }

        void success() {
            this.success = true;
            this.endTime = System.currentTimeMillis();
        }

        float duration() {
            return (float)(this.endTime - this.startTime) / 1000.0f;
        }
    }
}

