/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.service;

import com.gitblit.IStoredSettings;
import com.gitblit.models.Mailing;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(MailService.class);
    private final Queue<Message> queue = new ConcurrentLinkedQueue<Message>();
    private final Session session;
    private final IStoredSettings settings;

    public MailService(IStoredSettings settings) {
        this.settings = settings;
        final String mailUser = settings.getString("mail.username", null);
        final String mailPassword = settings.getString("mail.password", null);
        boolean smtps = settings.getBoolean("mail.smtps", false);
        boolean starttls = settings.getBoolean("mail.starttls", false);
        boolean authenticate = !StringUtils.isEmpty(mailUser) && !StringUtils.isEmpty(mailPassword);
        String server2 = settings.getString("mail.server", "");
        if (StringUtils.isEmpty(server2)) {
            this.session = null;
            return;
        }
        int port = settings.getInteger("mail.port", 25);
        boolean isGMail = false;
        if (server2.equals("smtp.gmail.com")) {
            port = 465;
            isGMail = true;
        }
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", server2);
        props.setProperty("mail.smtp.port", String.valueOf(port));
        props.setProperty("mail.smtp.auth", String.valueOf(authenticate));
        props.setProperty("mail.smtp.auths", String.valueOf(authenticate));
        props.setProperty("mail.smtp.starttls.enable", String.valueOf(starttls));
        if (isGMail || smtps) {
            props.setProperty("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.socketFactory.port", String.valueOf(port));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        this.session = !StringUtils.isEmpty(mailUser) && !StringUtils.isEmpty(mailPassword) ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(mailUser, mailPassword);
                return passwordAuthentication;
            }
        }) : Session.getInstance((Properties)props);
    }

    public boolean isReady() {
        return this.session != null;
    }

    public Message createMessage(Mailing mailing) {
        if (mailing.subject == null) {
            mailing.subject = "";
        }
        if (mailing.content == null) {
            mailing.content = "";
        }
        MailMessageImpl message = new MailMessageImpl(this.session, mailing.id);
        try {
            String fromAddress = this.settings.getString("mail.fromAddress", null);
            if (StringUtils.isEmpty(fromAddress)) {
                fromAddress = "gitblit@gitblit.com";
            }
            InternetAddress from = new InternetAddress(fromAddress, mailing.from == null ? "Gitblit" : mailing.from, "utf-8");
            message.setFrom((Address)from);
            Pattern validEmail = Pattern.compile("^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
            ArrayList<InternetAddress> to = new ArrayList<InternetAddress>();
            for (String address : mailing.toAddresses) {
                if (StringUtils.isEmpty(address) || !validEmail.matcher(address).find()) continue;
                try {
                    to.add(new InternetAddress(address));
                }
                catch (Throwable throwable) {}
            }
            ArrayList<InternetAddress> cc = new ArrayList<InternetAddress>();
            for (String address : mailing.ccAddresses) {
                if (StringUtils.isEmpty(address) || !validEmail.matcher(address).find()) continue;
                try {
                    cc.add(new InternetAddress(address));
                }
                catch (Throwable throwable) {}
            }
            if (this.settings.getBoolean("web.showEmailAddresses", true)) {
                if (to.size() > 0) {
                    message.setRecipients(Message.RecipientType.TO, (Address[])to.toArray(new InternetAddress[to.size()]));
                }
                if (cc.size() > 0) {
                    message.setRecipients(Message.RecipientType.CC, (Address[])cc.toArray(new InternetAddress[cc.size()]));
                }
            } else {
                ArrayList<InternetAddress> bcc = new ArrayList<InternetAddress>();
                bcc.addAll(to);
                bcc.addAll(cc);
                message.setRecipients(Message.RecipientType.BCC, (Address[])bcc.toArray(new InternetAddress[bcc.size()]));
            }
            message.setSentDate(new Date());
            message.setSubject(MimeUtility.encodeText((String)mailing.subject, (String)"utf-8", (String)"B"));
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(mailing.content, "utf-8");
            if (Mailing.Type.html == mailing.type) {
                messagePart.setHeader("Content-Type", "text/html; charset=\"utf-8\"");
            } else {
                messagePart.setHeader("Content-Type", "text/plain; charset=\"utf-8\"");
            }
            MimeMultipart multiPart = new MimeMultipart();
            multiPart.addBodyPart((BodyPart)messagePart);
            if (mailing.hasAttachments()) {
                for (File file : mailing.attachments) {
                    if (!file.exists()) continue;
                    MimeBodyPart filePart = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(file);
                    filePart.setDataHandler(new DataHandler((DataSource)fds));
                    filePart.setFileName(fds.getName());
                    multiPart.addBodyPart((BodyPart)filePart);
                }
            }
            message.setContent((Multipart)multiPart);
        }
        catch (Exception e) {
            this.logger.error("Failed to properly create message", (Throwable)e);
        }
        return message;
    }

    public boolean hasEmptyQueue() {
        return this.queue.isEmpty();
    }

    public boolean queue(Message message) {
        if (!this.isReady()) {
            return false;
        }
        try {
            message.saveChanges();
        }
        catch (Throwable t) {
            this.logger.error("Failed to save changes to message!", t);
        }
        this.queue.add(message);
        return true;
    }

    @Override
    public void run() {
        if (!this.queue.isEmpty() && this.session != null) {
            ArrayList<Message> failures = new ArrayList<Message>();
            Message message = null;
            while ((message = this.queue.poll()) != null) {
                try {
                    if (this.settings.getBoolean("mail.debug", false)) {
                        this.logger.info("send: '" + StringUtils.trimString(message.getSubject(), 60) + "' to:" + StringUtils.trimString(Arrays.toString(message.getAllRecipients()), 300));
                    }
                    Transport.send((Message)message);
                }
                catch (SendFailedException sfe) {
                    if (this.settings.getBoolean("mail.debug", false)) {
                        this.logger.error("Failed to send message: {}", (Object)sfe.getMessage());
                        this.logger.info("   Invalid addresses: {}", (Object)Arrays.toString(sfe.getInvalidAddresses()));
                        this.logger.info("   Valid sent addresses: {}", (Object)Arrays.toString(sfe.getValidSentAddresses()));
                        this.logger.info("   Valid unset addresses: {}", (Object)Arrays.toString(sfe.getValidUnsentAddresses()));
                        this.logger.info("", (Throwable)sfe);
                    } else {
                        this.logger.error("Failed to send message: {}", (Object)sfe.getMessage(), (Object)sfe.getNextException());
                    }
                    failures.add(message);
                }
                catch (Throwable e) {
                    this.logger.error("Failed to send message", e);
                    failures.add(message);
                }
            }
            this.queue.addAll(failures);
        }
    }

    public void sendNow(Message message) throws Exception {
        Transport.send((Message)message);
    }

    private static class MailMessageImpl
    extends MimeMessage {
        final String id;

        MailMessageImpl(Session session, String id) {
            super(session);
            this.id = id;
        }

        protected void updateMessageID() throws MessagingException {
            if (!StringUtils.isEmpty(this.id)) {
                String hostname = "gitblit.com";
                String refid = "<" + this.id + "@" + hostname + ">";
                String mid = "<" + UUID.randomUUID().toString() + "@" + hostname + ">";
                this.setHeader("References", refid);
                this.setHeader("In-Reply-To", refid);
                this.setHeader("Message-Id", mid);
            }
        }
    }
}

