/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.service;

import com.gitblit.IStoredSettings;
import com.gitblit.git.ReceiveCommandEvent;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.JGitUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(MirrorService.class);
    private final Set<String> repairAttempted = Collections.synchronizedSet(new HashSet());
    private final IStoredSettings settings;
    private final IRepositoryManager repositoryManager;
    private AtomicBoolean running = new AtomicBoolean(false);
    private AtomicBoolean forceClose = new AtomicBoolean(false);
    private final UserModel gitblitUser;

    public MirrorService(IStoredSettings settings, IRepositoryManager repositoryManager) {
        this.settings = settings;
        this.repositoryManager = repositoryManager;
        this.gitblitUser = new UserModel("gitblit");
        this.gitblitUser.displayName = "Gitblit";
    }

    public boolean isReady() {
        return this.settings.getBoolean("git.enableMirroring", false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void close() {
        this.forceClose.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isReady()) {
            return;
        }
        this.running.set(true);
        for (String repositoryName : this.repositoryManager.getRepositoryList()) {
            if (this.forceClose.get()) break;
            if (this.repositoryManager.isCollectingGarbage(repositoryName)) {
                this.logger.debug("mirror is skipping {} garbagecollection", (Object)repositoryName);
                continue;
            }
            RepositoryModel model = null;
            Repository repository = null;
            try {
                model = this.repositoryManager.getRepositoryModel(repositoryName);
                if (!model.isMirror && !model.isBare) {
                    this.logger.debug("mirror is skipping {} !mirror !bare", (Object)repositoryName);
                    continue;
                }
                repository = this.repositoryManager.getRepository(repositoryName);
                if (repository == null) {
                    this.logger.warn(MessageFormat.format("MirrorExecutor is missing repository {0}?!?", repositoryName));
                    continue;
                }
                if (!this.repairAttempted.contains(repositoryName)) {
                    this.repairAttempted.add(repositoryName);
                    JGitUtils.repairFetchSpecs(repository);
                }
                StoredConfig rc = repository.getConfig();
                RemoteConfig mirror = null;
                List configs = RemoteConfig.getAllRemoteConfigs((Config)rc);
                for (RemoteConfig config : configs) {
                    if (!config.isMirror()) continue;
                    mirror = config;
                    break;
                }
                if (mirror == null) {
                    this.logger.debug("mirror is skipping {} no mirror remote found", (Object)repositoryName);
                    continue;
                }
                this.logger.debug("checking {} remote {} for ref updates", (Object)repositoryName, (Object)mirror.getName());
                boolean testing = false;
                Git git2 = new Git(repository);
                FetchResult result = git2.fetch().setRemote(mirror.getName()).setDryRun(false).call();
                Collection refUpdates = result.getTrackingRefUpdates();
                if (refUpdates.size() <= 0) continue;
                ReceiveCommand ticketBranchCmd = null;
                for (TrackingRefUpdate ru : refUpdates) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("updated mirror ");
                    sb.append(repositoryName);
                    sb.append(" ");
                    sb.append(ru.getRemoteName());
                    sb.append(" -> ");
                    sb.append(ru.getLocalName());
                    if (ru.getResult() == RefUpdate.Result.FORCED) {
                        sb.append(" (forced)");
                    }
                    sb.append(" ");
                    sb.append(ru.getOldObjectId() == null ? "" : ru.getOldObjectId().abbreviate(7).name());
                    sb.append("..");
                    sb.append(ru.getNewObjectId() == null ? "" : ru.getNewObjectId().abbreviate(7).name());
                    this.logger.info(sb.toString());
                    if (!"refs/meta/gitblit/tickets".equals(ru.getLocalName())) continue;
                    ReceiveCommand.Type type = null;
                    switch (ru.getResult()) {
                        case NEW: {
                            type = ReceiveCommand.Type.CREATE;
                            break;
                        }
                        case FAST_FORWARD: {
                            type = ReceiveCommand.Type.UPDATE;
                            break;
                        }
                        case FORCED: {
                            type = ReceiveCommand.Type.UPDATE_NONFASTFORWARD;
                            break;
                        }
                        default: {
                            type = null;
                        }
                    }
                    if (type == null) continue;
                    ticketBranchCmd = new ReceiveCommand(ru.getOldObjectId(), ru.getNewObjectId(), ru.getLocalName(), type);
                }
                if (ticketBranchCmd == null) continue;
                repository.fireEvent((RepositoryEvent)new ReceiveCommandEvent(model, ticketBranchCmd));
            }
            catch (Exception e) {
                this.logger.error("Error updating mirror " + repositoryName, (Throwable)e);
            }
            finally {
                if (repository == null) continue;
                repository.close();
            }
        }
        this.running.set(false);
    }
}

