/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.Constants;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.models.UserModel;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticationFilter
implements Filter {
    protected static final String CHALLENGE = "Basic realm=\"Gitblit\"";
    protected static final String SESSION_SECURED = "com.gitblit.secured";
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected IAuthenticationManager authenticationManager;

    protected AuthenticationFilter(IAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected boolean requiresClientCertificate() {
        return false;
    }

    protected String getFullUrl(HttpServletRequest httpRequest) {
        String servletUrl = httpRequest.getContextPath() + httpRequest.getServletPath();
        String url = httpRequest.getRequestURI().substring(servletUrl.length());
        String params = httpRequest.getQueryString();
        if (url.length() > 0 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        String fullUrl = url + (StringUtils.isEmpty(params) ? "" : "?" + params);
        return fullUrl;
    }

    protected UserModel getUser(HttpServletRequest httpRequest) {
        UserModel user = this.authenticationManager.authenticate(httpRequest, this.requiresClientCertificate());
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession oldSession = request.getSession(false);
        if (oldSession != null && oldSession.getAttribute(SESSION_SECURED) == null) {
            AuthenticationFilter authenticationFilter = this;
            synchronized (authenticationFilter) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                Enumeration e = oldSession.getAttributeNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    attributes.put(name, oldSession.getAttribute(name));
                    oldSession.removeAttribute(name);
                }
                oldSession.invalidate();
                HttpSession newSession = request.getSession(true);
                newSession.setAttribute(SESSION_SECURED, (Object)Boolean.TRUE);
                for (Map.Entry entry : attributes.entrySet()) {
                    newSession.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public static class AuthenticatedRequest
    extends HttpServletRequestWrapper {
        private UserModel user = DeepCopier.copy(UserModel.ANONYMOUS);

        public AuthenticatedRequest(HttpServletRequest req) {
            super(req);
        }

        UserModel getUser() {
            return this.user;
        }

        void setUser(UserModel user) {
            this.user = user;
        }

        public String getRemoteUser() {
            return this.user.username;
        }

        public boolean isUserInRole(String role) {
            if (role.equals(Constants.Role.ADMIN.getRole())) {
                return this.user.canAdmin();
            }
            return this.user.hasRepositoryPermission(role);
        }

        public Principal getUserPrincipal() {
            return this.user;
        }
    }
}

