/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IFilestoreManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.utils.CompressionUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DownloadZipServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LoggerFactory.getLogger(DownloadZipServlet.class);
    private IStoredSettings settings;
    private IRepositoryManager repositoryManager;
    private IFilestoreManager filestoreManager;

    @Inject
    public DownloadZipServlet(IStoredSettings settings, IRepositoryManager repositoryManager, IFilestoreManager filestoreManager) {
        this.settings = settings;
        this.repositoryManager = repositoryManager;
        this.filestoreManager = filestoreManager;
    }

    public static String asLink(String baseURL, String repository, String objectId, String path, Format format) {
        if (baseURL.length() > 0 && baseURL.charAt(baseURL.length() - 1) == '/') {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL + "/zip/" + "?r=" + repository + (path == null ? "" : "&p=" + path) + (objectId == null ? "" : "&h=" + objectId) + (format == null ? "" : "&format=" + format.name());
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.settings.getBoolean("web.allowZipDownloads", true)) {
            this.logger.warn("Zip downloads are disabled");
            response.sendError(403);
            return;
        }
        Format format = Format.zip;
        String repository = request.getParameter("r");
        String basePath = request.getParameter("p");
        String objectId = request.getParameter("h");
        String f = request.getParameter("format");
        if (!StringUtils.isEmpty(f)) {
            format = Format.fromName(f);
        }
        try {
            Repository r;
            String name = repository;
            if (name.indexOf(47) > -1) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            name = StringUtils.stripDotGit(name);
            if (!StringUtils.isEmpty(basePath)) {
                name = name + "-" + basePath.replace('/', '_');
            }
            if (!StringUtils.isEmpty(objectId)) {
                name = name + "-" + objectId;
            }
            if ((r = this.repositoryManager.getRepository(repository)) == null) {
                if (this.repositoryManager.isCollectingGarbage(repository)) {
                    this.error(response, MessageFormat.format("# Error\nGitblit is busy collecting garbage in {0}", repository));
                    return;
                }
                this.error(response, MessageFormat.format("# Error\nFailed to find repository {0}", repository));
                return;
            }
            RevCommit commit = JGitUtils.getCommit(r, objectId);
            if (commit == null) {
                this.error(response, MessageFormat.format("# Error\nFailed to find commit {0}", objectId));
                r.close();
                return;
            }
            Date date = JGitUtils.getCommitDate(commit);
            String contentType = "application/octet-stream";
            response.setContentType(contentType + "; charset=" + response.getCharacterEncoding());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + name + format.extension + "\"");
            response.setDateHeader("Last-Modified", date.getTime());
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            try {
                switch (format) {
                    case zip: {
                        CompressionUtils.zip(r, this.filestoreManager, basePath, objectId, (OutputStream)response.getOutputStream());
                        break;
                    }
                    case tar: {
                        CompressionUtils.tar(r, this.filestoreManager, basePath, objectId, (OutputStream)response.getOutputStream());
                        break;
                    }
                    case gz: {
                        CompressionUtils.gz(r, this.filestoreManager, basePath, objectId, (OutputStream)response.getOutputStream());
                        break;
                    }
                    case xz: {
                        CompressionUtils.xz(r, this.filestoreManager, basePath, objectId, (OutputStream)response.getOutputStream());
                        break;
                    }
                    case bzip2: {
                        CompressionUtils.bzip2(r, this.filestoreManager, basePath, objectId, (OutputStream)response.getOutputStream());
                    }
                }
                response.flushBuffer();
            }
            catch (IOException t) {
                String message;
                String string = message = t.getMessage() == null ? "" : t.getMessage().toLowerCase();
                if (message.contains("reset") || message.contains("broken pipe")) {
                    this.logger.error("Client aborted zip download: " + message);
                } else {
                    this.logger.error("Failed to write attachment to client", (Throwable)t);
                }
            }
            catch (Throwable t) {
                this.logger.error("Failed to write attachment to client", t);
            }
            r.close();
        }
        catch (Throwable t) {
            this.logger.error("Failed to write attachment to client", t);
        }
    }

    private void error(HttpServletResponse response, String mkd) throws ServletException, IOException, ParseException {
        String content = MarkdownUtils.transformMarkdown(mkd);
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().write(content);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public static enum Format {
        zip(".zip"),
        tar(".tar"),
        gz(".tar.gz"),
        xz(".tar.xz"),
        bzip2(".tar.bzip2");

        public final String extension;

        private Format(String ext) {
            this.extension = ext;
        }

        public static Format fromName(String name) {
            for (Format format : Format.values()) {
                if (!format.name().equalsIgnoreCase(name)) continue;
                return format;
            }
            return zip;
        }
    }
}

