/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.models.UserModel;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnforceAuthenticationFilter
implements Filter {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private IStoredSettings settings;
    private IAuthenticationManager authenticationManager;

    @Inject
    public EnforceAuthenticationFilter(IStoredSettings settings, IAuthenticationManager authenticationManager) {
        this.settings = settings;
        this.authenticationManager = authenticationManager;
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Boolean mustForceAuth = this.settings.getBoolean("web.authenticateViewPages", false) && this.settings.getBoolean("web.enforceHttpBasicAuthentication", false);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        UserModel user = this.authenticationManager.authenticate(httpRequest);
        if (mustForceAuth.booleanValue() && user == null) {
            this.logger.debug(MessageFormat.format("EnforceAuthFilter: user not authenticated for URL {0}!", request.toString()));
            String challenge = MessageFormat.format("Basic realm=\"{0}\"", this.settings.getString("web.siteName", ""));
            httpResponse.setHeader("WWW-Authenticate", challenge);
            httpResponse.sendError(401);
            return;
        }
        chain.doFilter(request, response);
    }
}

