/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IFederationManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.FederationModel;
import com.gitblit.models.FederationProposal;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.JsonServlet;
import com.gitblit.utils.FederationUtils;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class FederationServlet
extends JsonServlet {
    private static final long serialVersionUID = 1L;
    private IStoredSettings settings;
    private IUserManager userManager;
    private IRepositoryManager repositoryManager;
    private IFederationManager federationManager;

    @Inject
    public FederationServlet(IStoredSettings settings, IUserManager userManager, IRepositoryManager repositoryManager, IFederationManager federationManager) {
        this.settings = settings;
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
        this.federationManager = federationManager;
    }

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Constants.FederationRequest reqType = Constants.FederationRequest.fromName(request.getParameter("req"));
        this.logger.info(MessageFormat.format("Federation {0} request from {1}", new Object[]{reqType, request.getRemoteAddr()}));
        if (Constants.FederationRequest.POKE.equals((Object)reqType)) {
            this.logger.info("Received federation POKE from " + request.getRemoteAddr());
            return;
        }
        if (!this.settings.getBoolean("git.enableGitServlet", true)) {
            this.logger.warn("git.enableGitServlet must be set TRUE for federation requests.");
            response.sendError(403);
            return;
        }
        String uuid = this.settings.getString("federation.passphrase", "");
        if (StringUtils.isEmpty(uuid)) {
            this.logger.warn("federation.passphrase is not properly set!  Federation request denied.");
            response.sendError(403);
            return;
        }
        if (Constants.FederationRequest.PROPOSAL.equals((Object)reqType)) {
            FederationProposal proposal = this.deserialize(request, response, FederationProposal.class);
            if (proposal == null) {
                return;
            }
            if (!this.settings.getBoolean("federation.allowProposals", false)) {
                this.logger.error(MessageFormat.format("Rejected {0} federation proposal from {1}", proposal.tokenType.name(), proposal.url));
                response.setStatus(405);
                return;
            }
            boolean poked = false;
            try {
                poked = FederationUtils.poke(proposal.url);
            }
            catch (Exception e) {
                this.logger.error("Failed to poke origin", (Throwable)e);
            }
            if (!poked) {
                this.logger.error(MessageFormat.format("Failed to send federation poke to {0}", proposal.url));
                response.setStatus(406);
                return;
            }
            String gitblitUrl = this.settings.getString("web.canonicalUrl", null);
            if (StringUtils.isEmpty(gitblitUrl)) {
                gitblitUrl = HttpUtils.getGitblitURL(request);
            }
            this.federationManager.submitFederationProposal(proposal, gitblitUrl);
            this.logger.info(MessageFormat.format("Submitted {0} federation proposal to pull {1} repositories from {2}", proposal.tokenType.name(), proposal.repositories.size(), proposal.url));
            response.setStatus(200);
            return;
        }
        if (Constants.FederationRequest.STATUS.equals((Object)reqType)) {
            String remoteId = StringUtils.decodeFromHtml(request.getParameter("url"));
            String identification = MessageFormat.format("{0} ({1})", remoteId, request.getRemoteAddr());
            FederationModel results = this.deserialize(request, response, FederationModel.class);
            if (results == null) {
                return;
            }
            results.lastPull = new Date();
            int mins = TimeUtils.convertFrequencyToMinutes(results.frequency, 5);
            results.nextPull = new Date(System.currentTimeMillis() + (long)(mins * 60) * 1000L);
            this.federationManager.acknowledgeFederationStatus(identification, results);
            this.logger.info(MessageFormat.format("Received status of {0} federated repositories from {1}", results.getStatusList().size(), identification));
            response.setStatus(200);
            return;
        }
        String token = request.getParameter("token");
        List<String> tokens = this.federationManager.getFederationTokens();
        if (!tokens.contains(token)) {
            this.logger.warn(MessageFormat.format("Received Federation token ''{0}'' does not match the server tokens", token));
            response.sendError(403);
            return;
        }
        Cloneable result = null;
        if (Constants.FederationRequest.PULL_REPOSITORIES.equals((Object)reqType)) {
            String gitblitUrl = this.settings.getString("web.canonicalUrl", null);
            if (StringUtils.isEmpty(gitblitUrl)) {
                gitblitUrl = HttpUtils.getGitblitURL(request);
            }
            result = this.federationManager.getRepositories(gitblitUrl, token);
        } else if (Constants.FederationRequest.PULL_SETTINGS.equals((Object)reqType)) {
            if (!this.federationManager.validateFederationRequest(reqType, token)) {
                this.logger.warn(MessageFormat.format("Federation token from {0} not authorized to pull SETTINGS", request.getRemoteAddr()));
                response.sendError(403);
                return;
            }
            HashMap<String, RepositoryModel> map = new HashMap<String, RepositoryModel>();
            List<String> keys = this.settings.getAllKeys(null);
            for (String key : keys) {
                map.put(key, (RepositoryModel)((Object)this.settings.getString(key, "")));
            }
            result = map;
        } else if (Constants.FederationRequest.PULL_USERS.equals((Object)reqType)) {
            if (!this.federationManager.validateFederationRequest(reqType, token)) {
                this.logger.warn(MessageFormat.format("Federation token from {0} not authorized to pull USERS", request.getRemoteAddr()));
                response.sendError(403);
                return;
            }
            List<String> usernames = this.userManager.getAllUsernames();
            ArrayList<UserModel> users = new ArrayList<UserModel>();
            for (String username : usernames) {
                UserModel user = this.userManager.getUserModel(username);
                if (user.excludeFromFederation) continue;
                users.add(user);
            }
            result = users;
        } else if (Constants.FederationRequest.PULL_TEAMS.equals((Object)reqType)) {
            if (!this.federationManager.validateFederationRequest(reqType, token)) {
                this.logger.warn(MessageFormat.format("Federation token from {0} not authorized to pull TEAMS", request.getRemoteAddr()));
                response.sendError(403);
                return;
            }
            List<String> teamnames = this.userManager.getAllTeamNames();
            ArrayList<TeamModel> teams = new ArrayList<TeamModel>();
            for (String teamname : teamnames) {
                TeamModel user = this.userManager.getTeamModel(teamname);
                teams.add(user);
            }
            result = teams;
        } else if (Constants.FederationRequest.PULL_SCRIPTS.equals((Object)reqType)) {
            if (!this.federationManager.validateFederationRequest(reqType, token)) {
                this.logger.warn(MessageFormat.format("Federation token from {0} not authorized to pull SCRIPTS", request.getRemoteAddr()));
                response.sendError(403);
                return;
            }
            HashMap<String, String> scripts = new HashMap<String, String>();
            HashSet<String> names = new HashSet<String>();
            names.addAll(this.settings.getStrings("groovy.preReceiveScripts"));
            names.addAll(this.settings.getStrings("groovy.postReceiveScripts"));
            for (TeamModel team : this.userManager.getAllTeams()) {
                names.addAll(team.preReceiveScripts);
                names.addAll(team.postReceiveScripts);
            }
            File scriptsFolder = this.repositoryManager.getHooksFolder();
            for (String name : names) {
                File file = new File(scriptsFolder, name);
                if (!file.exists() && !file.getName().endsWith(".groovy")) {
                    file = new File(scriptsFolder, name + ".groovy");
                }
                if (file.exists()) {
                    String content = FileUtils.readContent(file, "\n");
                    scripts.put(name, content);
                    continue;
                }
                this.logger.warn(MessageFormat.format("Failed to find push script \"{0}\"", name));
            }
            result = scripts;
        }
        this.serialize(response, result);
    }
}

