/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IFederationManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.AccessRestrictionFilter;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class GitFilter
extends AccessRestrictionFilter {
    static final String GIT_RECEIVE_PACK = "/git-receive-pack";
    static final String GIT_UPLOAD_PACK = "/git-upload-pack";
    static final String CLONE_BUNDLE = "/clone.bundle";
    static final String GIT_LFS = "/info/lfs";
    static final String[] SUFFIXES = new String[]{"/git-receive-pack", "/git-upload-pack", "/info/refs", "/HEAD", "/objects", "/info/lfs", "/clone.bundle"};
    private IStoredSettings settings;
    private IFederationManager federationManager;

    @Inject
    public GitFilter(IStoredSettings settings, IRuntimeManager runtimeManager, IAuthenticationManager authenticationManager, IRepositoryManager repositoryManager, IFederationManager federationManager) {
        super(runtimeManager, authenticationManager, repositoryManager);
        this.settings = settings;
        this.federationManager = federationManager;
    }

    public static String getRepositoryName(String url) {
        String repository = url;
        if (repository.contains("?")) {
            repository = repository.substring(0, repository.indexOf("?"));
        }
        for (String urlSuffix : SUFFIXES) {
            if (repository.indexOf(urlSuffix) <= -1) continue;
            repository = repository.substring(0, repository.indexOf(urlSuffix));
        }
        return repository;
    }

    @Override
    protected String extractRepositoryName(String url) {
        return GitFilter.getRepositoryName(url);
    }

    @Override
    protected String getUrlRequestAction(String suffix) {
        if (!StringUtils.isEmpty(suffix)) {
            if (suffix.startsWith(GIT_RECEIVE_PACK)) {
                return GIT_RECEIVE_PACK;
            }
            if (suffix.startsWith(GIT_UPLOAD_PACK)) {
                return GIT_UPLOAD_PACK;
            }
            if (suffix.contains("?service=git-receive-pack")) {
                return GIT_RECEIVE_PACK;
            }
            if (suffix.contains("?service=git-upload-pack")) {
                return GIT_UPLOAD_PACK;
            }
            if (suffix.startsWith(GIT_LFS)) {
                return GIT_LFS;
            }
            if (suffix.startsWith(CLONE_BUNDLE)) {
                return CLONE_BUNDLE;
            }
            return GIT_UPLOAD_PACK;
        }
        return null;
    }

    @Override
    protected UserModel getUser(HttpServletRequest httpRequest) {
        UserModel user = this.authenticationManager.authenticate(httpRequest, this.requiresClientCertificate());
        if (user == null) {
            user = this.federationManager.authenticate(httpRequest);
        }
        return user;
    }

    @Override
    protected boolean isCreationAllowed(String action) {
        if (action == null) {
            return false;
        }
        if (GIT_LFS.equals(action)) {
            return false;
        }
        if (CLONE_BUNDLE.equals(action)) {
            return false;
        }
        return this.settings.getBoolean("git.allowCreateOnPush", true);
    }

    @Override
    protected boolean isActionAllowed(RepositoryModel repository, String action, String method) {
        return !GIT_LFS.equals(action) || method.matches("GET|POST|PUT|HEAD");
    }

    @Override
    protected boolean requiresClientCertificate() {
        return this.settings.getBoolean("git.requiresClientCertificate", false);
    }

    @Override
    protected boolean requiresAuthentication(RepositoryModel repository, String action, String method) {
        if (GIT_UPLOAD_PACK.equals(action)) {
            return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.CLONE);
        }
        if (GIT_RECEIVE_PACK.equals(action)) {
            return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.PUSH);
        }
        if (GIT_LFS.equals(action)) {
            if (method.matches("GET|HEAD")) {
                return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.CLONE);
            }
            return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.PUSH);
        }
        return false;
    }

    @Override
    protected boolean canAccess(RepositoryModel repository, UserModel user, String action) {
        if (!this.settings.getBoolean("git.enableGitServlet", true)) {
            return false;
        }
        if (GIT_RECEIVE_PACK.equals(action)) {
            return true;
        }
        if (GIT_UPLOAD_PACK.equals(action)) {
            if (user.canClone(repository)) {
                return true;
            }
            this.logger.warn(MessageFormat.format("user {0} is not authorized to clone {1}", user.username, repository));
            return false;
        }
        return true;
    }

    @Override
    protected RepositoryModel createRepository(UserModel user, String repository, String action) {
        boolean isPush;
        boolean bl = isPush = !StringUtils.isEmpty(action) && GIT_RECEIVE_PACK.equals(action);
        if (GIT_LFS.equals(action)) {
            return null;
        }
        if (isPush) {
            if (user.canCreate(repository)) {
                if (repository.startsWith("../")) {
                    this.logger.error(MessageFormat.format("Illegal relative path in repository name! {0}", repository));
                    return null;
                }
                if (repository.contains("/../")) {
                    this.logger.error(MessageFormat.format("Illegal relative path in repository name! {0}", repository));
                    return null;
                }
                Character c = StringUtils.findInvalidCharacter(repository);
                if (c != null) {
                    this.logger.error(MessageFormat.format("Invalid character '{0}' in repository name {1}!", c, repository));
                    return null;
                }
                RepositoryModel model = new RepositoryModel();
                model.name = repository;
                model.addOwner(user.username);
                model.projectPath = StringUtils.getFirstPathElement(repository);
                if (model.isUsersPersonalRepository(user.username)) {
                    model.authorizationControl = Constants.AuthorizationControl.NAMED;
                    model.accessRestriction = Constants.AccessRestrictionType.VIEW;
                } else {
                    model.authorizationControl = Constants.AuthorizationControl.fromName(this.settings.getString("git.defaultAuthorizationControl", ""));
                    model.accessRestriction = Constants.AccessRestrictionType.fromName(this.settings.getString("git.defaultAccessRestriction", "PUSH"));
                }
                try {
                    this.repositoryManager.updateRepositoryModel(model.name, model, true);
                    this.logger.info(MessageFormat.format("{0} created {1} ON-PUSH", user.username, model.name));
                    return this.repositoryManager.getRepositoryModel(model.name);
                }
                catch (GitBlitException e) {
                    this.logger.error(MessageFormat.format("{0} failed to create repository {1} ON-PUSH!", user.username, model.name), (Throwable)e);
                }
            } else {
                this.logger.warn(MessageFormat.format("{0} is not permitted to create repository {1} ON-PUSH!", user.username, repository));
            }
        }
        return null;
    }

    @Override
    protected String getAuthenticationHeader(HttpServletRequest httpRequest, String action) {
        if (GIT_LFS.equals(action) && GitFilter.hasContentInRequestHeader(httpRequest, "Accept", "application/vnd.git-lfs+json")) {
            return "LFS-Authenticate";
        }
        return super.getAuthenticationHeader(httpRequest, action);
    }

    @Override
    protected boolean hasValidRequestHeader(String action, HttpServletRequest request) {
        if (GIT_LFS.equals(action) && request.getMethod().equals("POST") && (!GitFilter.hasContentInRequestHeader(request, "Accept", "application/vnd.git-lfs+json") || !GitFilter.hasContentInRequestHeader(request, "Content-Type", "application/vnd.git-lfs+json"))) {
            return false;
        }
        return super.hasValidRequestHeader(action, request);
    }
}

