/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.git.GitblitReceivePackFactory;
import com.gitblit.git.GitblitUploadPackFactory;
import com.gitblit.git.RepositoryResolver;
import com.gitblit.manager.IGitblit;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.GitFilter;

@Singleton
public class GitServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final GitFilter gitFilter = new GitFilter();

    @Inject
    public GitServlet(IGitblit gitblit) {
        this.gitFilter.setRepositoryResolver(new RepositoryResolver(gitblit));
        this.gitFilter.setUploadPackFactory(new GitblitUploadPackFactory(gitblit));
        this.gitFilter.setReceivePackFactory(new GitblitReceivePackFactory(gitblit));
    }

    public void init(final ServletConfig config) throws ServletException {
        this.gitFilter.init(new FilterConfig(){

            public String getFilterName() {
                return GitServlet.this.gitFilter.getClass().getName();
            }

            public String getInitParameter(String name) {
                return config.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return config.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return config.getServletContext();
            }
        });
        this.init();
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.gitFilter.doFilter((ServletRequest)req, (ServletResponse)res, new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                ((HttpServletResponse)response).sendError(404);
            }
        });
    }

    public void destroy() {
        this.gitFilter.destroy();
    }
}

