/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.FileSettings;
import com.gitblit.IStoredSettings;
import com.gitblit.WebXmlSettings;
import com.gitblit.extensions.LifeCycleListener;
import com.gitblit.guice.CoreModule;
import com.gitblit.guice.WebModule;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IFederationManager;
import com.gitblit.manager.IFilestoreManager;
import com.gitblit.manager.IGitblit;
import com.gitblit.manager.IManager;
import com.gitblit.manager.INotificationManager;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IProjectManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IServicesManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.tickets.ITicketService;
import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.utils.ContainerUtils;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitContext
extends GuiceServletContextListener {
    private static GitblitContext gitblit;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<IManager> managers = new ArrayList<IManager>();
    private final IStoredSettings goSettings;
    private final File goBaseFolder;

    public GitblitContext() {
        this(null, null);
    }

    public GitblitContext(IStoredSettings settings, File baseFolder) {
        this.goSettings = settings;
        this.goBaseFolder = baseFolder;
        gitblit = this;
    }

    public static <X extends IManager> X getManager(Class<X> managerClass) {
        for (IManager manager : GitblitContext.gitblit.managers) {
            if (!managerClass.isAssignableFrom(manager.getClass())) continue;
            return (X)manager;
        }
        return null;
    }

    protected Injector getInjector() {
        return Guice.createInjector((Module[])this.getModules());
    }

    protected AbstractModule[] getModules() {
        return new AbstractModule[]{new CoreModule(), new WebModule()};
    }

    public final void contextInitialized(ServletContextEvent contextEvent) {
        super.contextInitialized(contextEvent);
        ServletContext context = contextEvent.getServletContext();
        this.startCore(context);
    }

    protected void startCore(ServletContext context) {
        File baseFolder;
        Injector injector = (Injector)context.getAttribute(Injector.class.getName());
        IStoredSettings runtimeSettings = (IStoredSettings)injector.getInstance(IStoredSettings.class);
        if (this.goSettings != null) {
            baseFolder = this.configureGO(context, this.goSettings, this.goBaseFolder, runtimeSettings);
        } else {
            WebXmlSettings webxmlSettings = new WebXmlSettings(context);
            String contextRealPath = context.getRealPath("/");
            File contextFolder = contextRealPath != null ? new File(contextRealPath) : null;
            String defaultBase = "${contextFolder}/WEB-INF/data";
            String base = this.getBaseFolderPath(defaultBase);
            baseFolder = !StringUtils.isEmpty(System.getenv("OPENSHIFT_DATA_DIR")) && defaultBase.equals(base) ? this.configureExpress(context, webxmlSettings, contextFolder, runtimeSettings) : this.configureWAR(context, webxmlSettings, contextFolder, runtimeSettings);
            ContainerUtils.CVE_2007_0450.test(runtimeSettings);
        }
        this.logManager(IRuntimeManager.class);
        IRuntimeManager runtime = (IRuntimeManager)injector.getInstance(IRuntimeManager.class);
        runtime.setBaseFolder(baseFolder);
        runtime.getStatus().isGO = this.goSettings != null;
        runtime.getStatus().servletContainer = context.getServerInfo();
        runtime.start();
        this.managers.add(runtime);
        this.loadManager(injector, IPluginManager.class);
        this.startManager(injector, INotificationManager.class);
        this.startManager(injector, IUserManager.class);
        this.startManager(injector, IAuthenticationManager.class);
        this.startManager(injector, IPublicKeyManager.class);
        this.startManager(injector, IRepositoryManager.class);
        this.startManager(injector, IProjectManager.class);
        this.startManager(injector, IFederationManager.class);
        this.startManager(injector, ITicketService.class);
        this.startManager(injector, IGitblit.class);
        this.startManager(injector, IServicesManager.class);
        this.startManager(injector, IFilestoreManager.class);
        this.startManager(injector, IPluginManager.class);
        this.logger.info("");
        this.logger.info("All managers started.");
        this.logger.info("");
        IPluginManager pluginManager = (IPluginManager)injector.getInstance(IPluginManager.class);
        for (LifeCycleListener listener : pluginManager.getExtensions(LifeCycleListener.class)) {
            try {
                listener.onStartup();
            }
            catch (Throwable t) {
                this.logger.error(null, t);
            }
        }
    }

    private String lookupBaseFolderFromJndi() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp/env");
            return (String)env.lookup("baseFolder");
        }
        catch (NamingException n) {
            this.logger.error("Failed to get JNDI env-entry: " + n.getExplanation());
            return null;
        }
    }

    protected String getBaseFolderPath(String defaultBaseFolder) {
        String specifiedBaseFolder = System.getProperty("GITBLIT_HOME", this.lookupBaseFolderFromJndi());
        if (!StringUtils.isEmpty(System.getenv("GITBLIT_HOME"))) {
            specifiedBaseFolder = System.getenv("GITBLIT_HOME");
        }
        if (!StringUtils.isEmpty(specifiedBaseFolder)) {
            return specifiedBaseFolder;
        }
        return defaultBaseFolder;
    }

    protected <X extends IManager> X loadManager(Injector injector, Class<X> clazz) {
        IManager x = (IManager)injector.getInstance(clazz);
        return (X)x;
    }

    protected <X extends IManager> X startManager(Injector injector, Class<X> clazz) {
        X x = this.loadManager(injector, clazz);
        this.logManager(clazz);
        return this.startManager(x);
    }

    protected <X extends IManager> X startManager(X x) {
        x.start();
        this.managers.add(x);
        return x;
    }

    protected void logManager(Class<? extends IManager> clazz) {
        this.logger.info("");
        this.logger.info("----[{}]----", (Object)clazz.getName());
    }

    public final void contextDestroyed(ServletContextEvent contextEvent) {
        super.contextDestroyed(contextEvent);
        ServletContext context = contextEvent.getServletContext();
        this.destroyContext(context);
    }

    protected void destroyContext(ServletContext context) {
        this.logger.info("Gitblit context destroyed by servlet container.");
        IPluginManager pluginManager = GitblitContext.getManager(IPluginManager.class);
        if (pluginManager != null) {
            for (LifeCycleListener listener : pluginManager.getExtensions(LifeCycleListener.class)) {
                try {
                    listener.onShutdown();
                }
                catch (Throwable t) {
                    this.logger.error(null, t);
                }
            }
        }
        for (IManager manager : this.managers) {
            this.logger.debug("stopping {}", (Object)manager.getClass().getSimpleName());
            manager.stop();
        }
    }

    protected File configureGO(ServletContext context, IStoredSettings goSettings, File goBaseFolder, IStoredSettings runtimeSettings) {
        this.logger.debug("configuring Gitblit GO");
        runtimeSettings.merge(goSettings);
        File base = goBaseFolder;
        return base;
    }

    protected File configureWAR(ServletContext context, WebXmlSettings webxmlSettings, File contextFolder, IStoredSettings runtimeSettings) {
        this.logger.debug("configuring Gitblit WAR");
        this.logger.info("WAR contextFolder is " + (contextFolder != null ? contextFolder.getAbsolutePath() : "<empty>"));
        String webXmlPath = webxmlSettings.getString("baseFolder", "${contextFolder}/WEB-INF/data");
        if (webXmlPath.contains("${contextFolder}") && contextFolder == null) {
            this.logger.error("");
            this.logger.error(MessageFormat.format("\"{0}\" depends on \"{1}\" but \"{2}\" is returning NULL for \"{1}\"!", "baseFolder", "${contextFolder}", context.getServerInfo()));
            this.logger.error(MessageFormat.format("Please specify a non-parameterized path for <context-param> {0} in web.xml!!", "baseFolder"));
            this.logger.error(MessageFormat.format("OR configure your servlet container to specify a \"{0}\" parameter in the context configuration!!", "baseFolder"));
            this.logger.error("");
        }
        String baseFolderPath = this.getBaseFolderPath(webXmlPath);
        File baseFolder = FileUtils.resolveParameter("${contextFolder}", contextFolder, baseFolderPath);
        baseFolder.mkdirs();
        this.extractResources(context, "/WEB-INF/data/", baseFolder);
        File localSettings = new File(baseFolder, "gitblit.properties");
        FileSettings fileSettings = new FileSettings(localSettings.getAbsolutePath());
        runtimeSettings.merge(fileSettings);
        return baseFolder;
    }

    private File configureExpress(ServletContext context, WebXmlSettings webxmlSettings, File contextFolder, IStoredSettings runtimeSettings) {
        File warGitignores;
        String gitignorePath;
        File localGitignores;
        File warScripts;
        this.logger.debug("configuring Gitblit Express");
        String openShift = System.getenv("OPENSHIFT_DATA_DIR");
        File base = new File(openShift);
        this.logger.info("EXPRESS contextFolder is " + contextFolder.getAbsolutePath());
        String path = webxmlSettings.getString("groovy.scriptsFolder", "groovy");
        File localScripts = FileUtils.resolveParameter("${baseFolder}", base, path);
        if (!localScripts.exists() && !(warScripts = new File(contextFolder, "/WEB-INF/data/groovy")).equals(localScripts)) {
            try {
                FileUtils.copy(localScripts, warScripts.listFiles());
            }
            catch (IOException e) {
                this.logger.error(MessageFormat.format("Failed to copy included Groovy scripts from {0} to {1}", warScripts, localScripts));
            }
        }
        if (!(localGitignores = FileUtils.resolveParameter("${baseFolder}", base, gitignorePath = webxmlSettings.getString("git.gitignoreFolder", "gitignore"))).exists() && !(warGitignores = new File(contextFolder, "/WEB-INF/data/gitignore")).equals(localGitignores)) {
            try {
                FileUtils.copy(localGitignores, warGitignores.listFiles());
            }
            catch (IOException e) {
                this.logger.error(MessageFormat.format("Failed to copy included .gitignore files from {0} to {1}", warGitignores, localGitignores));
            }
        }
        runtimeSettings.merge(webxmlSettings);
        File localSettings = new File(base, "gitblit.properties");
        FileSettings fileSettings = new FileSettings(localSettings.getAbsolutePath());
        runtimeSettings.merge(fileSettings);
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractResources(ServletContext context, String path, File toDir) {
        Set resources = context.getResourcePaths(path);
        if (resources == null) {
            this.logger.warn("There are no WAR resources to extract from {}", (Object)path);
            return;
        }
        for (String resource : resources) {
            File f = new File(toDir, resource.substring(path.length()));
            if (f.exists()) continue;
            InputStream is = null;
            OutputStream os = null;
            try {
                if (resource.charAt(resource.length() - 1) == '/') {
                    f.mkdirs();
                    this.extractResources(context, resource, f);
                    continue;
                }
                f.getParentFile().mkdirs();
                is = context.getResourceAsStream(resource);
                os = new FileOutputStream(f);
                byte[] buffer = new byte[4096];
                int len = 0;
                while ((len = is.read(buffer)) > -1) {
                    os.write(buffer, 0, len);
                }
            }
            catch (FileNotFoundException e) {
                this.logger.error("Failed to find resource \"" + resource + "\"", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error("Failed to copy resource \"" + resource + "\" to " + f, (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (os == null) continue;
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

