/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.utils.JsonUtils;
import com.gitblit.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected final int forbiddenCode = 403;
    protected final int notAllowedCode = 405;
    protected final int failureCode = 500;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected <X> X deserialize(HttpServletRequest request, HttpServletResponse response, Class<X> clazz) throws IOException {
        String json = this.readJson(request, response);
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        X object = JsonUtils.fromJsonString(json.toString(), clazz);
        return object;
    }

    protected <X> X deserialize(HttpServletRequest request, HttpServletResponse response, Type type) throws IOException {
        String json = this.readJson(request, response);
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        Object object = JsonUtils.fromJsonString(json.toString(), type);
        return object;
    }

    private String readJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BufferedReader reader = request.getReader();
        StringBuilder json = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            json.append(line);
        }
        reader.close();
        if (json.length() == 0) {
            this.logger.error(MessageFormat.format("Failed to receive json data from {0}", request.getRemoteAddr()));
            response.setStatus(400);
            return null;
        }
        return json.toString();
    }

    protected void serialize(HttpServletResponse response, Object o) throws IOException {
        if (o != null) {
            String json = JsonUtils.toJsonString(o);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            response.getWriter().append(json);
        }
    }
}

