/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.manager.IRuntimeManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class LogoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final long lastModified = System.currentTimeMillis();
    private IRuntimeManager runtimeManager;

    @Inject
    public LogoServlet(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    protected long getLastModified(HttpServletRequest req) {
        File file = this.runtimeManager.getFileOrFolder("web.headerLogo", "${baseFolder}/logo.png");
        if (file.exists()) {
            return Math.max(lastModified, file.lastModified());
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try (InputStream is = null;){
            String contentType = null;
            File file = this.runtimeManager.getFileOrFolder("web.headerLogo", "${baseFolder}/logo.png");
            if (file.exists()) {
                ServletContext context = request.getSession().getServletContext();
                contentType = context.getMimeType(file.getName());
                response.setContentLength((int)file.length());
                response.setDateHeader("Last-Modified", Math.max(lastModified, file.lastModified()));
                is = new FileInputStream(file);
            } else {
                response.setDateHeader("Last-Modified", lastModified);
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/logo.png");
            }
            if (contentType == null) {
                contentType = "image/png";
            }
            response.setContentType(contentType);
            response.setHeader("Cache-Control", "public, max-age=3600, must-revalidate");
            ServletOutputStream os = response.getOutputStream();
            byte[] buf = new byte[4096];
            int bytesRead = is.read(buf);
            while (bytesRead != -1) {
                os.write(buf, 0, bytesRead);
                bytesRead = is.read(buf);
            }
            os.flush();
        }
    }
}

