/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.Constants;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.AccessRestrictionFilter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class RawFilter
extends AccessRestrictionFilter {
    @Inject
    public RawFilter(IRuntimeManager runtimeManager, IAuthenticationManager authenticationManager, IRepositoryManager repositoryManager) {
        super(runtimeManager, authenticationManager, repositoryManager);
    }

    @Override
    protected String extractRepositoryName(String url) {
        String repository = "";
        Repository r = null;
        int offset = 0;
        while (r == null) {
            int slash = url.indexOf(47, offset);
            repository = slash == -1 ? url : url.substring(0, slash);
            r = this.repositoryManager.getRepository(repository, false);
            if (r == null) {
                offset = slash + 1;
            } else {
                r.close();
            }
            if (!repository.equals(url)) continue;
            break;
        }
        return repository;
    }

    @Override
    protected String getUrlRequestAction(String suffix) {
        return "VIEW";
    }

    @Override
    protected boolean isCreationAllowed(String action) {
        return false;
    }

    @Override
    protected boolean isActionAllowed(RepositoryModel repository, String action, String method) {
        return true;
    }

    @Override
    protected boolean requiresAuthentication(RepositoryModel repository, String action, String method) {
        return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.VIEW);
    }

    @Override
    protected boolean canAccess(RepositoryModel repository, UserModel user, String action) {
        return user.canView(repository);
    }
}

