/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.AuthenticationFilter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class RpcFilter
extends AuthenticationFilter {
    private IStoredSettings settings;
    private IRuntimeManager runtimeManager;

    @Inject
    public RpcFilter(IStoredSettings settings, IRuntimeManager runtimeManager, IAuthenticationManager authenticationManager) {
        super(authenticationManager);
        this.settings = settings;
        this.runtimeManager = runtimeManager;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String fullUrl = this.getFullUrl(httpRequest);
        Constants.RpcRequest requestType = Constants.RpcRequest.fromName(httpRequest.getParameter("req"));
        if (requestType == null) {
            httpResponse.sendError(501);
            return;
        }
        boolean adminRequest = requestType.exceeds(Constants.RpcRequest.LIST_SETTINGS);
        if (!this.settings.getBoolean("web.enableRpcServlet", true)) {
            this.logger.warn("web.enableRpcServlet must be set TRUE for rpc requests.");
            httpResponse.sendError(403);
            return;
        }
        boolean authenticateView = this.settings.getBoolean("web.authenticateViewPages", false);
        boolean authenticateAdmin = this.settings.getBoolean("web.authenticateAdminPages", true);
        AuthenticationFilter.AuthenticatedRequest authenticatedRequest = new AuthenticationFilter.AuthenticatedRequest(httpRequest);
        UserModel user = this.getUser(httpRequest);
        if (user != null) {
            authenticatedRequest.setUser(user);
        }
        if (adminRequest && !this.settings.getBoolean("web.enableRpcManagement", false)) {
            this.logger.warn(MessageFormat.format("{0} must be set TRUE for {1} rpc requests.", "web.enableRpcManagement", requestType.toString()));
            httpResponse.sendError(403);
            return;
        }
        if (adminRequest && authenticateAdmin || !adminRequest && authenticateView) {
            if (user == null) {
                if (this.runtimeManager.isDebugMode()) {
                    this.logger.info(MessageFormat.format("RPC: CHALLENGE {0}", fullUrl));
                }
                httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Gitblit\"");
                httpResponse.sendError(401);
                return;
            }
            if (user.canAdmin() || !adminRequest) {
                this.newSession((HttpServletRequest)authenticatedRequest, httpResponse);
                this.logger.info(MessageFormat.format("RPC: {0} ({1}) authenticated", fullUrl, 100));
                chain.doFilter((ServletRequest)authenticatedRequest, (ServletResponse)httpResponse);
                return;
            }
            this.logger.warn(MessageFormat.format("RPC: {0} forbidden to access {1}", user.username, fullUrl));
            httpResponse.sendError(403);
            return;
        }
        if (this.runtimeManager.isDebugMode()) {
            this.logger.info(MessageFormat.format("RPC: {0} ({1}) unauthenticated", fullUrl, 100));
        }
        chain.doFilter((ServletRequest)authenticatedRequest, (ServletResponse)httpResponse);
    }
}

