/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class SparkleShareInviteServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private IStoredSettings settings;
    private IUserManager userManager;
    private IAuthenticationManager authenticationManager;
    private IRepositoryManager repositoryManager;

    @Inject
    public SparkleShareInviteServlet(IStoredSettings settings, IUserManager userManager, IAuthenticationManager authenticationManager, IRepositoryManager repositoryManager) {
        this.settings = settings;
        this.userManager = userManager;
        this.authenticationManager = authenticationManager;
        this.repositoryManager = repositoryManager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserModel user;
        String sshDisplayHost;
        String path;
        int sshPort = this.settings.getInteger("git.sshPort", 0);
        if (sshPort == 0) {
            response.setStatus(403);
            response.getWriter().append("SSH is not active on this server!");
            return;
        }
        int sshDisplayPort = this.settings.getInteger("git.sshAdvertisedPort", sshPort);
        String repoUrl = request.getPathInfo().substring(1);
        if (repoUrl.endsWith(".xml")) {
            repoUrl = repoUrl.substring(0, repoUrl.length() - 4);
        }
        String username = null;
        int fetchIndex = repoUrl.indexOf(64);
        if (fetchIndex > -1) {
            username = repoUrl.substring(0, fetchIndex);
            path = repoUrl.substring(fetchIndex + 1);
        } else {
            path = repoUrl;
        }
        String host = request.getServerName();
        String url = this.settings.getString("web.canonicalUrl", "https://localhost:8443");
        if (!StringUtils.isEmpty(url) && url.indexOf("localhost") == -1) {
            host = new URL(url).getHost();
        }
        if ((sshDisplayHost = this.settings.getString("git.sshAdvertisedHost", "")).isEmpty()) {
            sshDisplayHost = host;
        }
        if ((user = StringUtils.isEmpty(username) ? this.authenticationManager.authenticate(request) : this.userManager.getUserModel(username)) == null || user.disabled) {
            response.setStatus(403);
            response.getWriter().append("Access is not permitted!");
            return;
        }
        RepositoryModel model = this.repositoryManager.getRepositoryModel(path);
        if (model == null) {
            response.setStatus(404);
            response.getWriter().append(MessageFormat.format("Repository \"{0}\" not found!", path));
            return;
        }
        if (!user.canRewindRef(model)) {
            response.setStatus(403);
            response.getWriter().append(MessageFormat.format("{0} does not have RW+ permissions to \"{1}\"!", user.username, model.name));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<sparkleshare><invite>\n");
        sb.append(MessageFormat.format("<address>ssh://{0}@{1}:{2,number,0}/</address>\n", user.username, sshDisplayHost, sshDisplayPort));
        sb.append(MessageFormat.format("<remote_path>/{0}</remote_path>\n", model.name));
        int fanoutPort = this.settings.getInteger("fanout.port", 0);
        if (fanoutPort > 0) {
            sb.append(MessageFormat.format("<announcements_url>tcp://{0}:{1,number,0}</announcements_url>\n", request.getServerName(), fanoutPort));
        }
        sb.append("</invite></sparkleshare>\n");
        response.setContentType("application/xml");
        response.setContentLength(sb.length());
        response.getWriter().append(sb.toString());
    }
}

