/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.git.ReceiveCommandEvent;
import com.gitblit.manager.INotificationManager;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.PathModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.tickets.ITicketService;
import com.gitblit.tickets.TicketSerializer;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;

@Singleton
public class BranchTicketService
extends ITicketService
implements RefsChangedListener {
    public static final String BRANCH = "refs/meta/gitblit/tickets";
    private static final String JOURNAL = "journal.json";
    private static final String ID_PATH = "id/";
    private final Map<String, AtomicLong> lastAssignedId = new ConcurrentHashMap<String, AtomicLong>();

    @Inject
    public BranchTicketService(IRuntimeManager runtimeManager, IPluginManager pluginManager, INotificationManager notificationManager, IUserManager userManager, IRepositoryManager repositoryManager) {
        super(runtimeManager, pluginManager, notificationManager, userManager, repositoryManager);
        Repository.getGlobalListenerList().addRefsChangedListener((RefsChangedListener)this);
    }

    @Override
    public void onStart() {
        this.log.info("{} started", (Object)this.getClass().getSimpleName());
    }

    @Override
    protected void resetCachesImpl() {
        this.lastAssignedId.clear();
    }

    @Override
    protected void resetCachesImpl(RepositoryModel repository) {
        if (this.lastAssignedId.containsKey(repository.name)) {
            this.lastAssignedId.get(repository.name).set(0L);
        }
    }

    @Override
    protected void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onRefsChanged(RefsChangedEvent event) {
        if (!(event instanceof ReceiveCommandEvent)) {
            return;
        }
        ReceiveCommandEvent branchUpdate = (ReceiveCommandEvent)event;
        RepositoryModel repository = branchUpdate.model;
        ReceiveCommand cmd = branchUpdate.cmd;
        try {
            switch (cmd.getType()) {
                case CREATE: 
                case UPDATE_NONFASTFORWARD: {
                    this.reindex(repository);
                    break;
                }
                case UPDATE: {
                    this.resetCaches(repository);
                    long start = System.nanoTime();
                    this.log.info("incrementally indexing {} ticket branch due to received ref update", (Object)repository.name);
                    try (Repository db = this.repositoryManager.getRepository(repository.name);){
                        HashSet<Long> ids = new HashSet<Long>();
                        List<PathModel.PathChangeModel> paths = JGitUtils.getFilesInRange(db, cmd.getOldId().getName(), cmd.getNewId().getName());
                        for (PathModel.PathChangeModel path : paths) {
                            String tid;
                            long ticketId;
                            String name = path.name.substring(path.name.lastIndexOf(47) + 1);
                            if (!JOURNAL.equals(name) || ids.contains(ticketId = Long.parseLong(tid = path.path.split("/")[2]))) continue;
                            ids.add(ticketId);
                            TicketModel ticket = this.getTicket(repository, ticketId);
                            this.log.info(MessageFormat.format("indexing ticket #{0,number,0}: {1}", ticketId, ticket.title));
                            this.indexer.index(ticket);
                        }
                        long end = System.nanoTime();
                        this.log.info("incremental indexing of {0} ticket(s) completed in {1} msecs", (Object)ids.size(), (Object)TimeUnit.NANOSECONDS.toMillis(end - start));
                        break;
                    }
                }
                default: {
                    this.log.warn("Unexpected receive type {} in BranchTicketService.onRefsChanged" + cmd.getType());
                }
            }
        }
        catch (Exception e) {
            this.log.error("failed to reindex " + repository.name, (Throwable)e);
        }
    }

    private RefModel getTicketsBranch(Repository db) {
        List<RefModel> refs = JGitUtils.getRefs(db, "refs/");
        Ref oldRef = null;
        for (RefModel ref : refs) {
            if (ref.reference.getName().equals(BRANCH)) {
                return ref;
            }
            if (!ref.reference.getName().equals("refs/gitblit/tickets")) continue;
            oldRef = ref.reference;
        }
        if (oldRef != null) {
            try {
                RefRename cmd = db.renameRef(oldRef.getName(), BRANCH);
                cmd.setRefLogIdent(new PersonIdent("Gitblit", "gitblit@localhost"));
                cmd.setRefLogMessage("renamed " + oldRef.getName() + " => " + BRANCH);
                RefUpdate.Result res = cmd.rename();
                switch (res) {
                    case RENAMED: {
                        this.log.info(db.getDirectory() + " " + cmd.getRefLogMessage());
                        return this.getTicketsBranch(db);
                    }
                }
                this.log.error("failed to rename " + oldRef.getName() + " => " + BRANCH + " (" + res.name() + ")");
            }
            catch (IOException e) {
                this.log.error("failed to rename tickets branch", (Throwable)e);
            }
        }
        return null;
    }

    private void createTicketsBranch(Repository db) {
        JGitUtils.createOrphanBranch(db, BRANCH, null);
    }

    private String toTicketPath(long ticketId) {
        StringBuilder sb = new StringBuilder();
        sb.append(ID_PATH);
        long m = ticketId % 100L;
        if (m < 10L) {
            sb.append('0');
        }
        sb.append(m);
        sb.append('/');
        sb.append(ticketId);
        return sb.toString();
    }

    private String toAttachmentPath(long ticketId, String filename) {
        return this.toTicketPath(ticketId) + "/attachments/" + filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTicketsFile(Repository db, String file) {
        try (RevWalk rw = null;){
            ObjectId treeId = db.resolve("refs/meta/gitblit/tickets^{tree}");
            if (treeId == null) {
                String string = null;
                return string;
            }
            rw = new RevWalk(db);
            RevTree tree = rw.lookupTree((AnyObjectId)treeId);
            if (tree != null) {
                String string = JGitUtils.getStringContent(db, tree, file, "UTF-8");
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTicketsFile(Repository db, String file, String content, String createdBy, String msg) {
        if (this.getTicketsBranch(db) == null) {
            this.createTicketsBranch(db);
        }
        DirCache newIndex = DirCache.newInCore();
        DirCacheBuilder builder = newIndex.builder();
        try (ObjectInserter inserter = db.newObjectInserter();){
            DirCacheEntry idIndexEntry = new DirCacheEntry(file);
            idIndexEntry.setLength(content.length());
            idIndexEntry.setLastModified(System.currentTimeMillis());
            idIndexEntry.setFileMode(FileMode.REGULAR_FILE);
            idIndexEntry.setObjectId((AnyObjectId)inserter.insert(3, content.getBytes("UTF-8")));
            builder.add(idIndexEntry);
            HashSet<String> ignorePaths = new HashSet<String>();
            ignorePaths.add(file);
            for (DirCacheEntry entry : JGitUtils.getTreeEntries(db, BRANCH, ignorePaths)) {
                builder.add(entry);
            }
            builder.finish();
            this.commitIndex(db, newIndex, createdBy, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTicket(RepositoryModel repository, long ticketId) {
        boolean hasTicket = false;
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            RevCommit tip;
            RefModel ticketsBranch = this.getTicketsBranch(db);
            if (ticketsBranch == null) {
                boolean bl = false;
                return bl;
            }
            String ticketPath = this.toTicketPath(ticketId);
            hasTicket = !JGitUtils.getFilesInPath(db, ticketPath, tip = JGitUtils.getCommit(db, BRANCH)).isEmpty();
        }
        return hasTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<Long> getIds(RepositoryModel repository) {
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            if (this.getTicketsBranch(db) == null) {
                Set<Long> set = Collections.emptySet();
                return set;
            }
            TreeSet<Long> ids = new TreeSet<Long>();
            List<PathModel> paths = JGitUtils.getDocuments(db, Arrays.asList("json"), BRANCH);
            for (PathModel path : paths) {
                String name = path.name.substring(path.name.lastIndexOf(47) + 1);
                if (!JOURNAL.equals(name)) continue;
                String tid = path.path.split("/")[2];
                long ticketId = Long.parseLong(tid);
                ids.add(ticketId);
            }
            TreeSet<Long> treeSet = ids;
            return treeSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long assignNewId(RepositoryModel repository) {
        long newId = 0L;
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            AtomicLong lastId;
            if (this.getTicketsBranch(db) == null) {
                this.createTicketsBranch(db);
            }
            if (!this.lastAssignedId.containsKey(repository.name)) {
                this.lastAssignedId.put(repository.name, new AtomicLong(0L));
            }
            if ((lastId = this.lastAssignedId.get(repository.name)).get() <= 0L) {
                Set<Long> ids = this.getIds(repository);
                for (long id : ids) {
                    if (id <= lastId.get()) continue;
                    lastId.set(id);
                }
            }
            newId = lastId.incrementAndGet();
            String journalPath = this.toTicketPath(newId) + "/" + JOURNAL;
            this.writeTicketsFile(db, journalPath, "", "gitblit", "assigned id #" + newId);
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TicketModel> getTickets(RepositoryModel repository, ITicketService.TicketFilter filter) {
        ArrayList<TicketModel> list = new ArrayList<TicketModel>();
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            RefModel ticketsBranch = this.getTicketsBranch(db);
            if (ticketsBranch == null) {
                ArrayList<TicketModel> arrayList = list;
                return arrayList;
            }
            List<PathModel> paths = JGitUtils.getDocuments(db, Arrays.asList("json"), BRANCH);
            for (PathModel path : paths) {
                String json;
                String name = path.name.substring(path.name.lastIndexOf(47) + 1);
                if (!JOURNAL.equals(name) || StringUtils.isEmpty(json = this.readTicketsFile(db, path.path))) continue;
                try {
                    String tid = path.path.split("/")[2];
                    long ticketId = Long.parseLong(tid);
                    List<TicketModel.Change> changes = TicketSerializer.deserializeJournal(json);
                    if (ArrayUtils.isEmpty(changes)) {
                        this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)path.path);
                        continue;
                    }
                    TicketModel ticket = TicketModel.buildTicket(changes);
                    ticket.project = repository.projectPath;
                    ticket.repository = repository.name;
                    ticket.number = ticketId;
                    if (filter == null) {
                        list.add(ticket);
                        continue;
                    }
                    if (!filter.accept(ticket)) continue;
                    list.add(ticket);
                }
                catch (Exception e) {
                    this.log.error("failed to deserialize {}/{}\n{}", new Object[]{repository, path.path, e.getMessage()});
                    this.log.error(null, (Throwable)e);
                }
            }
            Collections.sort(list);
            ArrayList<TicketModel> arrayList = list;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TicketModel getTicketImpl(RepositoryModel repository, long ticketId) {
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            List<TicketModel.Change> changes = this.getJournal(db, ticketId);
            if (ArrayUtils.isEmpty(changes)) {
                this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)ticketId);
                TicketModel ticketModel = null;
                return ticketModel;
            }
            TicketModel ticket = TicketModel.buildTicket(changes);
            if (ticket != null) {
                ticket.project = repository.projectPath;
                ticket.repository = repository.name;
                ticket.number = ticketId;
            }
            TicketModel ticketModel = ticket;
            return ticketModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<TicketModel.Change> getJournalImpl(RepositoryModel repository, long ticketId) {
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            List<TicketModel.Change> changes = this.getJournal(db, ticketId);
            if (ArrayUtils.isEmpty(changes)) {
                this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)ticketId);
                List<TicketModel.Change> list = null;
                return list;
            }
            List<TicketModel.Change> list = changes;
            return list;
        }
    }

    private List<TicketModel.Change> getJournal(Repository db, long ticketId) {
        RefModel ticketsBranch = this.getTicketsBranch(db);
        if (ticketsBranch == null) {
            return new ArrayList<TicketModel.Change>();
        }
        if (ticketId <= 0L) {
            return new ArrayList<TicketModel.Change>();
        }
        String journalPath = this.toTicketPath(ticketId) + "/" + JOURNAL;
        String json = this.readTicketsFile(db, journalPath);
        if (StringUtils.isEmpty(json)) {
            return new ArrayList<TicketModel.Change>();
        }
        List<TicketModel.Change> list = TicketSerializer.deserializeJournal(json);
        return list;
    }

    @Override
    public boolean supportsAttachments() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TicketModel.Attachment getAttachment(RepositoryModel repository, long ticketId, String filename) {
        if (ticketId <= 0L) {
            return null;
        }
        TicketModel ticket = this.getTicket(repository, ticketId);
        TicketModel.Attachment attachment = ticket.getAttachment(filename);
        if (attachment == null) {
            return null;
        }
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            String attachmentPath = this.toAttachmentPath(ticketId, attachment.name);
            RevTree tree = JGitUtils.getCommit(db, BRANCH).getTree();
            byte[] content = JGitUtils.getByteContent(db, tree, attachmentPath, false);
            attachment.content = content;
            attachment.size = content.length;
            TicketModel.Attachment attachment2 = attachment;
            return attachment2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized boolean deleteTicketImpl(RepositoryModel repository, TicketModel ticket, String deletedBy) {
        if (ticket == null) {
            throw new RuntimeException("must specify a ticket!");
        }
        boolean success = false;
        try (Repository db = this.repositoryManager.getRepository(ticket.repository);){
            RefModel ticketsBranch = this.getTicketsBranch(db);
            if (ticketsBranch == null) {
                throw new RuntimeException("refs/meta/gitblit/tickets does not exist!");
            }
            String ticketPath = this.toTicketPath(ticket.number);
            TreeWalk treeWalk = null;
            try {
                ObjectId treeId = db.resolve("refs/meta/gitblit/tickets^{tree}");
                DirCache index = DirCache.newInCore();
                DirCacheBuilder builder = index.builder();
                treeWalk = new TreeWalk(db);
                int hIdx = -1;
                if (treeId != null) {
                    hIdx = treeWalk.addTree((AnyObjectId)treeId);
                }
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    String path = treeWalk.getPathString();
                    CanonicalTreeParser hTree = null;
                    if (hIdx != -1) {
                        hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                    }
                    if (path.startsWith(ticketPath) || hTree == null) continue;
                    DirCacheEntry entry = new DirCacheEntry(path);
                    entry.setObjectId((AnyObjectId)hTree.getEntryObjectId());
                    entry.setFileMode(hTree.getEntryFileMode());
                    builder.add(entry);
                }
                builder.finish();
                success = this.commitIndex(db, index, deletedBy, "- " + ticket.number);
                if (treeWalk == null) return success;
            }
            catch (Throwable t) {
                try {
                    this.log.error(MessageFormat.format("Failed to delete ticket {0,number,0} from {1}", ticket.number, db.getDirectory()), t);
                    return success;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (treeWalk != null) {
                        treeWalk.close();
                    }
                }
            }
            treeWalk.close();
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean commitChangeImpl(RepositoryModel repository, long ticketId, TicketModel.Change change) {
        boolean success = false;
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            DirCache index = this.createIndex(db, ticketId, change);
            success = this.commitIndex(db, index, change.author, "#" + ticketId);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirCache createIndex(Repository db, long ticketId, TicketModel.Change change) throws IOException, ClassNotFoundException, NoSuchFieldException {
        String ticketPath = this.toTicketPath(ticketId);
        DirCache newIndex = DirCache.newInCore();
        DirCacheBuilder builder = newIndex.builder();
        TreeSet<String> ignorePaths = new TreeSet<String>();
        try (ObjectInserter inserter = db.newObjectInserter();){
            List<TicketModel.Change> changes = this.getJournal(db, ticketId);
            changes.add(change);
            String journal = TicketSerializer.serializeJournal(changes).trim();
            byte[] journalBytes = journal.getBytes("UTF-8");
            String journalPath = ticketPath + "/" + JOURNAL;
            DirCacheEntry journalEntry = new DirCacheEntry(journalPath);
            journalEntry.setLength(journalBytes.length);
            journalEntry.setLastModified(change.date.getTime());
            journalEntry.setFileMode(FileMode.REGULAR_FILE);
            journalEntry.setObjectId((AnyObjectId)inserter.insert(3, journalBytes));
            builder.add(journalEntry);
            ignorePaths.add(journalEntry.getPathString());
            if (change.hasAttachments()) {
                for (TicketModel.Attachment attachment : change.attachments) {
                    String path = this.toAttachmentPath(ticketId, attachment.name);
                    ignorePaths.add(path);
                    DirCacheEntry entry = new DirCacheEntry(path);
                    entry.setLength(attachment.content.length);
                    entry.setLastModified(change.date.getTime());
                    entry.setFileMode(FileMode.REGULAR_FILE);
                    entry.setObjectId((AnyObjectId)inserter.insert(3, attachment.content));
                    builder.add(entry);
                }
            }
            for (DirCacheEntry entry : JGitUtils.getTreeEntries(db, BRANCH, ignorePaths)) {
                builder.add(entry);
            }
            builder.finish();
        }
        return newIndex;
    }

    private boolean commitIndex(Repository db, DirCache index, String author, String message) throws IOException, ConcurrentRefUpdateException {
        boolean forceCommit = true;
        boolean success = false;
        ObjectId headId = db.resolve("refs/meta/gitblit/tickets^{commit}");
        if (headId == null) {
            this.createTicketsBranch(db);
        }
        success = JGitUtils.commitIndex(db, BRANCH, index, headId, true, author, "gitblit@localhost", message);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean deleteAllImpl(RepositoryModel repository) {
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            RefModel branch = this.getTicketsBranch(db);
            if (branch != null) {
                boolean bl = JGitUtils.deleteBranchRef(db, BRANCH);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        return false;
    }

    @Override
    protected boolean renameImpl(RepositoryModel oldRepository, RepositoryModel newRepository) {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

