/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.models.TicketModel;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class QueryResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String project;
    public String repository;
    public long number;
    public String createdBy;
    public Date createdAt;
    public String updatedBy;
    public Date updatedAt;
    public String dependsOn;
    public String title;
    public String body;
    public TicketModel.Status status;
    public String responsible;
    public String milestone;
    public String topic;
    public TicketModel.Type type;
    public String mergeSha;
    public String mergeTo;
    public List<String> labels;
    public List<String> attachments;
    public List<String> participants;
    public List<String> watchedby;
    public List<String> mentions;
    public TicketModel.Patchset patchset;
    public int commentsCount;
    public int votesCount;
    public int approvalsCount;
    public TicketModel.Priority priority;
    public TicketModel.Severity severity;
    public int docId;
    public int totalResults;

    public Date getDate() {
        return this.updatedAt == null ? this.createdAt : this.updatedAt;
    }

    public boolean isProposal() {
        return this.type != null && TicketModel.Type.Proposal == this.type;
    }

    public boolean isOpen() {
        return !this.status.isClosed();
    }

    public boolean isClosed() {
        return this.status.isClosed();
    }

    public boolean isMerged() {
        return TicketModel.Status.Merged == this.status && !StringUtils.isEmpty(this.mergeSha);
    }

    public boolean isWatching(String username) {
        return this.watchedby != null && this.watchedby.contains(username);
    }

    public List<String> getLabels() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.labels != null) {
            list.addAll(this.labels);
        }
        if (this.topic != null) {
            list.add(this.topic);
        }
        Collections.sort(list);
        return list;
    }

    public boolean equals(Object o) {
        if (o instanceof QueryResult) {
            return this.hashCode() == o.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return (this.repository + this.number).hashCode();
    }

    public String toString() {
        return this.repository + "-" + this.number;
    }
}

