/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.manager.INotificationManager;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.tickets.ITicketService;
import com.gitblit.tickets.TicketSerializer;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisException;

@Singleton
public class RedisTicketService
extends ITicketService {
    private final JedisPool pool;

    @Inject
    public RedisTicketService(IRuntimeManager runtimeManager, IPluginManager pluginManager, INotificationManager notificationManager, IUserManager userManager, IRepositoryManager repositoryManager) {
        super(runtimeManager, pluginManager, notificationManager, userManager, repositoryManager);
        String redisUrl = this.settings.getString("tickets.redis.url", "");
        this.pool = this.createPool(redisUrl);
    }

    @Override
    public void onStart() {
        this.log.info("{} started", (Object)this.getClass().getSimpleName());
        if (!this.isReady()) {
            this.log.warn("{} is not ready!", (Object)this.getClass().getSimpleName());
        }
    }

    @Override
    protected void resetCachesImpl() {
    }

    @Override
    protected void resetCachesImpl(RepositoryModel repository) {
    }

    @Override
    protected void close() {
        this.pool.destroy();
    }

    @Override
    public boolean isReady() {
        return this.pool != null;
    }

    private String key(RepositoryModel repository, KeyType key, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(repository.name).append(':');
        sb.append(key.name());
        if (!StringUtils.isEmpty(id)) {
            sb.append(':');
            sb.append(id);
        }
        return sb.toString();
    }

    private String key(RepositoryModel repository, KeyType key, long id) {
        return this.key(repository, key, "" + id);
    }

    private boolean isNull(String value) {
        return value == null || "nil".equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUrl() {
        Jedis jedis = this.pool.getResource();
        try {
            if (jedis != null) {
                Client client = jedis.getClient();
                String string = client.getHost() + ":" + client.getPort() + "/" + client.getDB();
                return string;
            }
        }
        catch (JedisException e) {
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTicket(RepositoryModel repository, long ticketId) {
        if (ticketId <= 0L) {
            return false;
        }
        Jedis jedis = this.pool.getResource();
        if (jedis == null) {
            return false;
        }
        try {
            Boolean exists = jedis.exists(this.key(repository, KeyType.journal, ticketId));
            boolean bl = exists != null && exists != false;
            return bl;
        }
        catch (JedisException e) {
            this.log.error("failed to check hasTicket from Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getIds(RepositoryModel repository) {
        TreeSet<Long> ids = new TreeSet<Long>();
        Jedis jedis = this.pool.getResource();
        try {
            Set keys = jedis.keys(this.key(repository, KeyType.journal, "*"));
            for (String tkey : keys) {
                String id = tkey.split(":")[2];
                long ticketId = Long.parseLong(id);
                ids.add(ticketId);
            }
        }
        catch (JedisException e) {
            this.log.error("failed to assign new ticket id in Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long assignNewId(RepositoryModel repository) {
        Jedis jedis = this.pool.getResource();
        try {
            long ticketNumber;
            String key = this.key(repository, KeyType.counter, null);
            String val = jedis.get(key);
            if (this.isNull(val)) {
                long lastId = 0L;
                Set<Long> ids = this.getIds(repository);
                for (long id : ids) {
                    if (id <= lastId) continue;
                    lastId = id;
                }
                jedis.set(key, "" + lastId);
            }
            long l = ticketNumber = jedis.incr(key).longValue();
            return l;
        }
        catch (JedisException e) {
            this.log.error("failed to assign new ticket id in Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TicketModel> getTickets(RepositoryModel repository, ITicketService.TicketFilter filter) {
        Jedis jedis = this.pool.getResource();
        ArrayList<TicketModel> list = new ArrayList<TicketModel>();
        if (jedis == null) {
            return list;
        }
        try {
            Set keys = jedis.keys(this.key(repository, KeyType.journal, "*"));
            for (String key : keys) {
                String id = key.split(":")[2];
                long ticketId = Long.parseLong(id);
                List<TicketModel.Change> changes = this.getJournal(jedis, repository, ticketId);
                if (ArrayUtils.isEmpty(changes)) {
                    this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)ticketId);
                    continue;
                }
                TicketModel ticket = TicketModel.buildTicket(changes);
                ticket.project = repository.projectPath;
                ticket.repository = repository.name;
                ticket.number = ticketId;
                if (filter == null) {
                    list.add(ticket);
                    continue;
                }
                if (!filter.accept(ticket)) continue;
                list.add(ticket);
            }
            Collections.sort(list);
        }
        catch (JedisException e) {
            this.log.error("failed to retrieve tickets from Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TicketModel getTicketImpl(RepositoryModel repository, long ticketId) {
        Jedis jedis = this.pool.getResource();
        if (jedis == null) {
            return null;
        }
        try {
            List<TicketModel.Change> changes = this.getJournal(jedis, repository, ticketId);
            if (ArrayUtils.isEmpty(changes)) {
                this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)ticketId);
                TicketModel ticketModel = null;
                return ticketModel;
            }
            TicketModel ticket = TicketModel.buildTicket(changes);
            ticket.project = repository.projectPath;
            ticket.repository = repository.name;
            ticket.number = ticketId;
            this.log.debug("rebuilt ticket {} from Redis @ {}", (Object)ticketId, (Object)this.getUrl());
            TicketModel ticketModel = ticket;
            return ticketModel;
        }
        catch (JedisException e) {
            this.log.error("failed to retrieve ticket from Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<TicketModel.Change> getJournalImpl(RepositoryModel repository, long ticketId) {
        Jedis jedis = this.pool.getResource();
        if (jedis == null) {
            return null;
        }
        try {
            List<TicketModel.Change> changes = this.getJournal(jedis, repository, ticketId);
            if (ArrayUtils.isEmpty(changes)) {
                this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)ticketId);
                List<TicketModel.Change> list = null;
                return list;
            }
            List<TicketModel.Change> list = changes;
            return list;
        }
        catch (JedisException e) {
            this.log.error("failed to retrieve journal from Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return null;
    }

    private List<TicketModel.Change> getJournal(Jedis jedis, RepositoryModel repository, long ticketId) throws JedisException {
        if (ticketId <= 0L) {
            return new ArrayList<TicketModel.Change>();
        }
        List entries = jedis.lrange(this.key(repository, KeyType.journal, ticketId), 0L, -1L);
        if (entries.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String entry : entries) {
                sb.append(entry).append(',');
            }
            sb.setLength(sb.length() - 1);
            sb.append(']');
            String journal = sb.toString();
            return TicketSerializer.deserializeJournal(journal);
        }
        return new ArrayList<TicketModel.Change>();
    }

    @Override
    public boolean supportsAttachments() {
        return false;
    }

    @Override
    public TicketModel.Attachment getAttachment(RepositoryModel repository, long ticketId, String filename) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean deleteTicketImpl(RepositoryModel repository, TicketModel ticket, String deletedBy) {
        boolean success = false;
        if (ticket == null) {
            throw new RuntimeException("must specify a ticket!");
        }
        Jedis jedis = this.pool.getResource();
        if (jedis == null) {
            return false;
        }
        try {
            Transaction t = jedis.multi();
            t.del(this.key(repository, KeyType.ticket, ticket.number));
            t.del(this.key(repository, KeyType.journal, ticket.number));
            t.exec();
            success = true;
            this.log.debug("deleted ticket {} from Redis @ {}", (Object)("" + ticket.number), (Object)this.getUrl());
        }
        catch (JedisException e) {
            this.log.error("failed to delete ticket from Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean commitChangeImpl(RepositoryModel repository, long ticketId, TicketModel.Change change) {
        Jedis jedis = this.pool.getResource();
        if (jedis == null) {
            return false;
        }
        try {
            List<TicketModel.Change> changes = this.getJournal(jedis, repository, ticketId);
            changes.add(change);
            TicketModel ticket = TicketModel.buildTicket(changes);
            String object = TicketSerializer.serialize(ticket);
            String journal = TicketSerializer.serialize(change);
            Transaction t = jedis.multi();
            t.set(this.key(repository, KeyType.ticket, ticketId), object);
            t.rpush(this.key(repository, KeyType.journal, ticketId), new String[]{journal});
            t.exec();
            this.log.debug("updated ticket {} in Redis @ {}", (Object)("" + ticketId), (Object)this.getUrl());
            boolean bl = true;
            return bl;
        }
        catch (JedisException e) {
            this.log.error("failed to update ticket cache in Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean deleteAllImpl(RepositoryModel repository) {
        Jedis jedis = this.pool.getResource();
        if (jedis == null) {
            return false;
        }
        boolean success = false;
        try {
            Set keys = jedis.keys(repository.name + ":*");
            if (keys.size() > 0) {
                Transaction t = jedis.multi();
                t.del(keys.toArray(new String[keys.size()]));
                t.exec();
            }
            success = true;
        }
        catch (JedisException e) {
            this.log.error("failed to delete all tickets in Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean renameImpl(RepositoryModel oldRepository, RepositoryModel newRepository) {
        Jedis jedis = this.pool.getResource();
        if (jedis == null) {
            return false;
        }
        boolean success = false;
        try {
            Set oldKeys = jedis.keys(oldRepository.name + ":*");
            Transaction t = jedis.multi();
            for (String oldKey : oldKeys) {
                String newKey = newRepository.name + oldKey.substring(oldKey.indexOf(58));
                t.rename(oldKey, newKey);
            }
            t.exec();
            success = true;
        }
        catch (JedisException e) {
            this.log.error("failed to rename tickets in Redis @ " + this.getUrl(), (Throwable)e);
            this.pool.returnBrokenResource(jedis);
            jedis = null;
        }
        finally {
            if (jedis != null) {
                this.pool.returnResource(jedis);
            }
        }
        return success;
    }

    private JedisPool createPool(String url) {
        JedisPool pool = null;
        if (!StringUtils.isEmpty(url)) {
            try {
                URI uri = URI.create(url);
                if (uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("redis")) {
                    int database = 0;
                    String password = null;
                    if (uri.getUserInfo() != null) {
                        password = uri.getUserInfo().split(":", 2)[1];
                    }
                    if (uri.getPath().indexOf(47) > -1) {
                        database = Integer.parseInt(uri.getPath().split("/", 2)[1]);
                    }
                    pool = new JedisPool(new GenericObjectPoolConfig(), uri.getHost(), uri.getPort(), 2000, password, database);
                } else {
                    pool = new JedisPool(url);
                }
            }
            catch (JedisException e) {
                this.log.error("failed to create a Redis pool!", (Throwable)e);
            }
        }
        return pool;
    }

    public String toString() {
        String url = this.getUrl();
        return this.getClass().getSimpleName() + " (" + (url == null ? "DISABLED" : url) + ")";
    }

    private static enum KeyType {
        journal,
        ticket,
        counter;

    }
}

