/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.tickets.QueryResult;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.List;

public class TicketLabel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name;
    public String color;
    public List<QueryResult> tickets;

    public TicketLabel(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.name = name;
        this.color = StringUtils.getColor(name);
    }

    public int getTotalTickets() {
        return this.tickets == null ? 0 : this.tickets.size();
    }

    public int getOpenTickets() {
        int cnt = 0;
        if (this.tickets != null) {
            for (QueryResult ticket : this.tickets) {
                if (ticket.status.isClosed()) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public int getClosedTickets() {
        int cnt = 0;
        if (this.tickets != null) {
            for (QueryResult ticket : this.tickets) {
                if (!ticket.status.isClosed()) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public String toString() {
        return this.name;
    }
}

