/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.models.TicketModel;
import com.gitblit.tickets.TicketLabel;
import java.util.Date;

public class TicketMilestone
extends TicketLabel {
    private static final long serialVersionUID = 1L;
    public TicketModel.Status status = TicketModel.Status.Open;
    public Date due;

    public TicketMilestone(String name) {
        super(name);
    }

    public boolean isOpen() {
        return this.status == TicketModel.Status.Open;
    }

    public boolean isOverdue() {
        return this.due == null ? false : System.currentTimeMillis() > this.due.getTime();
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public int getProgress() {
        int total = this.getTotalTickets();
        if (total == 0) {
            return 0;
        }
        return (int)((float)this.getClosedTickets() * 1.0f / ((float)total * 1.0f) * 100.0f);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

