/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.git;

import com.gitblit.IStoredSettings;
import com.gitblit.git.GitblitReceivePackFactory;
import com.gitblit.git.GitblitUploadPackFactory;
import com.gitblit.git.RepositoryResolver;
import com.gitblit.manager.IGitblit;
import com.gitblit.transport.git.GitDaemonClient;
import com.gitblit.transport.git.GitDaemonService;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitDaemon {
    private final Logger logger = LoggerFactory.getLogger(GitDaemon.class);
    public static final int DEFAULT_PORT = 9418;
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final GitDaemonService[] services;
    private final ThreadGroup processors;
    private AtomicBoolean run;
    private ServerSocket acceptSocket;
    private Thread acceptThread;
    private int timeout;
    private RepositoryResolver<GitDaemonClient> repositoryResolver;
    private UploadPackFactory<GitDaemonClient> uploadPackFactory;
    private ReceivePackFactory<GitDaemonClient> receivePackFactory;

    public GitDaemon(IGitblit gitblit) {
        IStoredSettings settings = gitblit.getSettings();
        int port = settings.getInteger("git.daemonPort", 0);
        String bindInterface = settings.getString("git.daemonBindInterface", "localhost");
        this.myAddress = StringUtils.isEmpty(bindInterface) ? new InetSocketAddress(port) : new InetSocketAddress(bindInterface, port);
        this.repositoryResolver = new RepositoryResolver(gitblit);
        this.uploadPackFactory = new GitblitUploadPackFactory<GitDaemonClient>(gitblit);
        this.receivePackFactory = new GitblitReceivePackFactory<GitDaemonClient>(gitblit);
        this.run = new AtomicBoolean(false);
        this.processors = new ThreadGroup("Git-Daemon");
        this.services = new GitDaemonService[]{new GitDaemonService("upload-pack", "uploadpack"){
            {
                this.setEnabled(true);
                this.setOverridable(false);
            }

            @Override
            protected void execute(GitDaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = GitDaemon.this.uploadPackFactory.create((Object)dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                up.upload(in, out, null);
            }
        }, new GitDaemonService("receive-pack", "receivepack"){
            {
                this.setEnabled(true);
                this.setOverridable(false);
            }

            @Override
            protected void execute(GitDaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                ReceivePack rp = GitDaemon.this.receivePackFactory.create((Object)dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                rp.receive(in, out, null);
            }
        }};
    }

    public int getPort() {
        return this.myAddress.getPort();
    }

    public String formatUrl(String servername, String repository) {
        if (this.getPort() == 9418) {
            return MessageFormat.format("git://{0}/{1}", servername, repository);
        }
        return MessageFormat.format("git://{0}:{1,number,0}/{2}", servername, this.getPort(), repository);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public synchronized void start() throws IOException {
        if (this.acceptThread != null) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        final ServerSocket listenSock = new ServerSocket(this.myAddress != null ? this.myAddress.getPort() : 0, 5, this.myAddress != null ? this.myAddress.getAddress() : null);
        this.myAddress = (InetSocketAddress)listenSock.getLocalSocketAddress();
        this.run.set(true);
        this.acceptSocket = listenSock;
        this.acceptThread = new Thread(this.processors, "Git-Daemon-Accept"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (GitDaemon.this.isRunning()) {
                    try {
                        GitDaemon.this.startClient(listenSock.accept());
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (IOException e) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    listenSock.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    GitDaemon.this.acceptSocket = null;
                }
            }
        };
        this.acceptThread.start();
        this.logger.info(MessageFormat.format("Git Daemon is listening on {0}:{1,number,0}", this.myAddress.getAddress().getHostAddress(), this.myAddress.getPort()));
    }

    public boolean isRunning() {
        return this.run.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.isRunning() && this.acceptThread != null) {
            this.run.set(false);
            this.logger.info("Git Daemon stopping...");
            try {
                this.acceptSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.acceptThread.join();
                this.logger.info("Git Daemon stopped.");
            }
            catch (InterruptedException e) {
                this.logger.error("Accept thread join interrupted", (Throwable)e);
            }
            finally {
                this.acceptThread = null;
            }
        }
    }

    private void startClient(final Socket s) {
        final GitDaemonClient dc = new GitDaemonClient(this);
        SocketAddress peer = s.getRemoteSocketAddress();
        if (peer instanceof InetSocketAddress) {
            dc.setRemoteAddress(((InetSocketAddress)peer).getAddress());
        }
        new Thread(this.processors, "Git-Daemon-Client " + peer.toString()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    dc.execute(s);
                }
                catch (ServiceNotEnabledException serviceNotEnabledException) {
                }
                catch (ServiceNotAuthorizedException serviceNotAuthorizedException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
    }

    synchronized GitDaemonService matchService(String cmd) {
        for (GitDaemonService d : this.services) {
            if (!d.handles(cmd)) continue;
            return d;
        }
        return null;
    }

    Repository openRepository(GitDaemonClient client, String name) throws ServiceMayNotContinueException {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open(client, name.substring(1));
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
        catch (ServiceNotEnabledException e) {
            return null;
        }
    }
}

