/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.manager.IManager;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.SshKey;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IPublicKeyManager
implements IManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final LoadingCache<String, List<SshKey>> keyCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).maximumSize(100L).build((CacheLoader)new CacheLoader<String, List<SshKey>>(){

        public List<SshKey> load(String username) {
            List<SshKey> keys = IPublicKeyManager.this.getKeysImpl(username);
            if (keys == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(keys);
        }
    });

    @Override
    public abstract IPublicKeyManager start();

    public abstract boolean isReady();

    @Override
    public abstract IPublicKeyManager stop();

    public final List<SshKey> getKeys(String username) {
        try {
            if (this.isStale(username)) {
                this.keyCache.invalidate((Object)username);
            }
            return (List)this.keyCache.get((Object)username);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            if (e.getMessage() == null || !e.getMessage().contains("returned null")) {
                this.log.error(MessageFormat.format("failed to retrieve keys for {0}", username), (Throwable)e);
            }
        }
        catch (ExecutionException e) {
            this.log.error(MessageFormat.format("failed to retrieve keys for {0}", username), (Throwable)e);
        }
        return null;
    }

    public final void renameUser(String oldName, String newName) {
        List<SshKey> keys = this.getKeys(oldName);
        if (keys == null || keys.isEmpty()) {
            return;
        }
        this.removeAllKeys(oldName);
        for (SshKey key : keys) {
            this.addKey(newName, key);
        }
    }

    protected abstract boolean isStale(String var1);

    protected abstract List<SshKey> getKeysImpl(String var1);

    public abstract boolean addKey(String var1, SshKey var2);

    public abstract boolean removeKey(String var1, SshKey var2);

    public abstract boolean removeAllKeys(String var1);

    public boolean supportsWritingKeys(UserModel user) {
        return user != null;
    }

    public boolean supportsCommentChanges(UserModel user) {
        return user != null;
    }

    public boolean supportsPermissionChanges(UserModel user) {
        return user != null;
    }
}

