/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.ldap.LdapConnection;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.transport.ssh.SshKey;
import com.gitblit.utils.StringUtils;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.util.GenericUtils;

public class LdapKeyManager
extends IPublicKeyManager {
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^([^\":]+):");
    private static final Pattern GB_PERM_PATTERN = Pattern.compile("(?i:gbPerm)\\s*=\\s*(?:\\\\\"|\")?\\s*([A-Za-z+-]+)");
    private final IStoredSettings settings;

    @Inject
    public LdapKeyManager(IStoredSettings settings) {
        this.settings = settings;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public LdapKeyManager start() {
        this.log.info(this.toString());
        return this;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public LdapKeyManager stop() {
        return this;
    }

    @Override
    protected boolean isStale(String username) {
        return true;
    }

    @Override
    protected List<SshKey> getKeysImpl(String username) {
        try (LdapConnection conn = new LdapConnection(this.settings);){
            if (conn.connect()) {
                this.log.info("loading ssh key for {} from LDAP directory", (Object)username);
                BindResult bindResult = conn.bind();
                if (bindResult == null) {
                    conn.close();
                    List<SshKey> list = null;
                    return list;
                }
                String pubKeyAttribute = this.settings.getString("realm.ldap.sshPublicKey", "sshPublicKey");
                String pkaPrefix = null;
                int idx = pubKeyAttribute.indexOf(58);
                if (idx > 0) {
                    pkaPrefix = pubKeyAttribute.substring(idx + 1);
                    pubKeyAttribute = pubKeyAttribute.substring(0, idx);
                }
                SearchResult result = conn.searchUser(this.getSimpleUsername(username), Arrays.asList(pubKeyAttribute));
                conn.close();
                if (result != null && result.getResultCode() == ResultCode.SUCCESS) {
                    if (result.getEntryCount() > 1) {
                        this.log.info("Found more than one entry for user {} in LDAP. Cannot retrieve SSH key.", (Object)username);
                        List<SshKey> list = null;
                        return list;
                    }
                    if (result.getEntryCount() < 1) {
                        this.log.info("Found no entry for user {} in LDAP. Cannot retrieve SSH key.", (Object)username);
                        List<SshKey> list = null;
                        return list;
                    }
                    SearchResultEntry foundUser = (SearchResultEntry)result.getSearchEntries().get(0);
                    String[] attrs = foundUser.getAttributeValues(pubKeyAttribute);
                    if (attrs == null || attrs.length == 0) {
                        this.log.info("found no keys for user {} under attribute {} in directory", (Object)username, (Object)pubKeyAttribute);
                        List<SshKey> list = null;
                        return list;
                    }
                    ArrayList<GbAuthorizedKeyEntry> authorizedKeys = new ArrayList<GbAuthorizedKeyEntry>(attrs.length);
                    Matcher m = PREFIX_PATTERN.matcher("");
                    for (int i = 0; i < attrs.length; ++i) {
                        String keyEntry = Joiner.on((String)"").join((Object[])attrs[i].replace("\r\n", "\n").split("\n"));
                        m.reset(keyEntry);
                        try {
                            if (m.lookingAt()) {
                                String prefix;
                                if (pkaPrefix == null || !pkaPrefix.equalsIgnoreCase(prefix = m.group(1).trim())) continue;
                                String s = keyEntry.substring(m.end());
                                authorizedKeys.add(GbAuthorizedKeyEntry.parseAuthorizedKeyEntry(s));
                                continue;
                            }
                            if (pkaPrefix != null) continue;
                            String s = keyEntry;
                            authorizedKeys.add(GbAuthorizedKeyEntry.parseAuthorizedKeyEntry(s));
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            this.log.info("Failed to parse key entry={}:", (Object)keyEntry, (Object)e.getMessage());
                        }
                    }
                    ArrayList<SshKey> keyList = new ArrayList<SshKey>(authorizedKeys.size());
                    for (GbAuthorizedKeyEntry keyEntry : authorizedKeys) {
                        try {
                            SshKey key = new SshKey(keyEntry.resolvePublicKey(null));
                            key.setComment(keyEntry.getComment());
                            this.setKeyPermissions(key, keyEntry);
                            keyList.add(key);
                        }
                        catch (IOException | GeneralSecurityException e) {
                            this.log.warn("Error resolving key entry for user {}. Entry={}", new Object[]{username, keyEntry, e});
                        }
                    }
                    ArrayList<SshKey> arrayList = keyList;
                    return arrayList;
                }
            }
        }
        return null;
    }

    @Override
    public boolean addKey(String username, SshKey key) {
        return false;
    }

    @Override
    public boolean removeKey(String username, SshKey key) {
        return false;
    }

    @Override
    public boolean removeAllKeys(String username) {
        return false;
    }

    @Override
    public boolean supportsWritingKeys(UserModel user) {
        return false;
    }

    @Override
    public boolean supportsCommentChanges(UserModel user) {
        return false;
    }

    @Override
    public boolean supportsPermissionChanges(UserModel user) {
        return false;
    }

    private void setKeyPermissions(SshKey key, GbAuthorizedKeyEntry keyEntry) {
        List<String> env = keyEntry.getLoginOptionValues("environment");
        if (env != null && !env.isEmpty()) {
            for (String envi : env) {
                Matcher m = GB_PERM_PATTERN.matcher(envi);
                if (!m.find()) continue;
                String perm = m.group(1).trim();
                Constants.AccessPermission ap = Constants.AccessPermission.fromCode(perm);
                if (ap == Constants.AccessPermission.NONE) {
                    ap = Constants.AccessPermission.valueOf(perm.toUpperCase());
                }
                if (ap == null || ap == Constants.AccessPermission.NONE) continue;
                try {
                    key.setPermission(ap);
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Incorrect permissions ({}) set for SSH key entry {}.", new Object[]{ap, envi, e});
                }
            }
        }
    }

    private String getSimpleUsername(String username) {
        int lastSlash = username.lastIndexOf(92);
        if (lastSlash > -1) {
            username = username.substring(lastSlash + 1);
        }
        return username;
    }

    private static class GbAuthorizedKeyEntry
    extends AuthorizedKeyEntry {
        private static final long serialVersionUID = 1L;
        private static final Pattern LEADIN_PATTERN = Pattern.compile("^((?:[^\\s\"]*|(?:\"(?:[^\"\\\\]|\\\\\"|\\\\)*\"))*\\s+)(.+)");
        private static final Pattern OPTION_PATTERN = Pattern.compile("([^\",]+|(?:\"(?:[^\"\\\\]|\\\\\"|\\\\)*\"))+");
        private Map<String, List<String>> loginOptionsMulti = Collections.emptyMap();

        private GbAuthorizedKeyEntry() {
        }

        List<String> getLoginOptionValues(String option) {
            return this.loginOptionsMulti.get(option);
        }

        public static GbAuthorizedKeyEntry parseAuthorizedKeyEntry(String line) throws IllegalArgumentException {
            GbAuthorizedKeyEntry entry;
            if (StringUtils.isEmpty(line = GenericUtils.trimToEmpty((String)line)) || line.charAt(0) == '#') {
                return null;
            }
            Matcher m = LEADIN_PATTERN.matcher(line);
            if (!m.lookingAt()) {
                throw new IllegalArgumentException("Bad format (no key data delimiter): " + line);
            }
            String keyType = m.group(1).trim();
            if (KeyUtils.getPublicKeyEntryDecoder((String)keyType) == null) {
                entry = GbAuthorizedKeyEntry.parseAuthorizedKeyEntry(m.group(2));
                if (entry == null) {
                    throw new IllegalArgumentException("Bad format (no key data after login options): " + line);
                }
                entry.parseAndSetLoginOptions(keyType);
            } else {
                int startPos = line.indexOf(32);
                if (startPos <= 0) {
                    throw new IllegalArgumentException("Bad format (no key data delimiter): " + line);
                }
                int endPos = line.indexOf(32, startPos + 1);
                if (endPos <= startPos) {
                    endPos = line.length();
                }
                String encData = endPos < line.length() - 1 ? line.substring(0, endPos).trim() : line;
                String comment = endPos < line.length() - 1 ? line.substring(endPos + 1).trim() : null;
                entry = (GbAuthorizedKeyEntry)GbAuthorizedKeyEntry.parsePublicKeyEntry((PublicKeyEntry)new GbAuthorizedKeyEntry(), (String)encData);
                entry.setComment(comment);
            }
            return entry;
        }

        private void parseAndSetLoginOptions(String options) {
            Matcher m = OPTION_PATTERN.matcher(options);
            if (!m.find()) {
                this.loginOptionsMulti = Collections.emptyMap();
            }
            TreeMap<String, List<String>> optsMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            do {
                ArrayList<String> opts;
                String p = m.group();
                if (StringUtils.isEmpty(p = GenericUtils.trimToEmpty((String)p))) continue;
                int pos = p.indexOf(61);
                String name = pos < 0 ? p : GenericUtils.trimToEmpty((String)p.substring(0, pos));
                CharSequence value = pos < 0 ? null : GenericUtils.trimToEmpty((String)p.substring(pos + 1));
                if ((value = GenericUtils.stripQuotes(value)) == null) {
                    value = Boolean.TRUE.toString();
                }
                if ((opts = (ArrayList<String>)optsMap.get(name)) == null) {
                    opts = new ArrayList<String>();
                    optsMap.put(name, opts);
                }
                opts.add(value.toString());
            } while (m.find());
            this.loginOptionsMulti = optsMap;
        }
    }
}

