/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.transport.ssh.SshKey;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryKeyManager
extends IPublicKeyManager {
    final Map<String, List<SshKey>> keys = new HashMap<String, List<SshKey>>();

    @Inject
    public MemoryKeyManager() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public MemoryKeyManager start() {
        this.log.info(this.toString());
        return this;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public MemoryKeyManager stop() {
        return this;
    }

    @Override
    protected boolean isStale(String username) {
        return true;
    }

    @Override
    protected List<SshKey> getKeysImpl(String username) {
        String id = username.toLowerCase();
        if (this.keys.containsKey(id)) {
            return this.keys.get(id);
        }
        return null;
    }

    @Override
    public boolean addKey(String username, SshKey key) {
        String id = username.toLowerCase();
        if (!this.keys.containsKey(id)) {
            this.keys.put(id, new ArrayList());
        }
        this.log.info("added {} key {}", (Object)username, (Object)key.getFingerprint());
        return this.keys.get(id).add(key);
    }

    @Override
    public boolean removeKey(String username, SshKey key) {
        String id = username.toLowerCase();
        if (!this.keys.containsKey(id)) {
            this.log.info("can't remove keys for {}", (Object)username);
            return false;
        }
        List<SshKey> list = this.keys.get(id);
        boolean success = list.remove(key);
        if (success) {
            this.log.info("removed {} key {}", (Object)username, (Object)key.getFingerprint());
        }
        if (list.isEmpty()) {
            this.keys.remove(id);
            this.log.info("no {} keys left, removed {}", (Object)username, (Object)username);
        }
        return success;
    }

    @Override
    public boolean removeAllKeys(String username) {
        String id = username.toLowerCase();
        this.keys.remove(id.toLowerCase());
        this.log.info("removed all keys for {}", (Object)username);
        return true;
    }
}

