/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.SshDaemonClient;
import java.util.Locale;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshKrbAuthenticator
extends GSSAuthenticator {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final IAuthenticationManager authManager;
    protected final boolean stripDomain;

    public SshKrbAuthenticator(IStoredSettings settings, IAuthenticationManager authManager) {
        String servicePrincipalName;
        this.authManager = authManager;
        String keytabString = settings.getString("git.sshKrb5Keytab", "");
        if (!keytabString.isEmpty()) {
            this.setKeytabFile(keytabString);
        }
        if (!(servicePrincipalName = settings.getString("git.sshKrb5ServicePrincipalName", "")).isEmpty()) {
            this.setServicePrincipalName(servicePrincipalName);
        }
        this.stripDomain = settings.getBoolean("git.sshKrb5StripDomain", false);
    }

    public boolean validateIdentity(ServerSession session, String identity) {
        UserModel user;
        int p;
        this.log.info("identify with kerberos {}", (Object)identity);
        SshDaemonClient client = (SshDaemonClient)session.getAttribute(SshDaemonClient.KEY);
        if (client.getUser() != null) {
            this.log.info("{} has already authenticated!", (Object)identity);
            return true;
        }
        String username = identity.toLowerCase(Locale.US);
        if (this.stripDomain && (p = username.indexOf(64)) > 0) {
            username = username.substring(0, p);
        }
        if ((user = this.authManager.authenticate(username)) != null) {
            client.setUser(user);
            return true;
        }
        this.log.warn("could not authenticate {} for SSH", (Object)username);
        return false;
    }
}

