/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.transport.ssh.SshDaemonClient;
import com.gitblit.transport.ssh.SshServerSession;
import java.net.SocketAddress;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaSession;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.session.ServerSessionImpl;
import org.apache.sshd.server.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshServerSessionFactory
extends SessionFactory {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SshServerSessionFactory(ServerFactoryManager server2) {
        super(server2);
    }

    protected ServerSessionImpl createSession(final IoSession io) throws Exception {
        this.log.info("creating ssh session from {}", (Object)io.getRemoteAddress());
        if (io instanceof MinaSession && ((MinaSession)io).getSession().getConfig() instanceof SocketSessionConfig) {
            ((SocketSessionConfig)((MinaSession)io).getSession().getConfig()).setKeepAlive(true);
        }
        SshServerSession session = (SshServerSession)super.createSession(io);
        SocketAddress peer = io.getRemoteAddress();
        SshDaemonClient client = new SshDaemonClient(peer);
        session.setAttribute(SshDaemonClient.KEY, client);
        session.addCloseSessionListener(new SshFutureListener<CloseFuture>(){

            public void operationComplete(CloseFuture future) {
                SshServerSessionFactory.this.log.info("closed ssh session from {}", (Object)io.getRemoteAddress());
            }
        });
        return session;
    }

    protected ServerSessionImpl doCreateSession(IoSession ioSession) throws Exception {
        return new SshServerSession(this.getServer(), ioSession);
    }
}

