/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.SshDaemonClient;
import java.util.Locale;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernamePasswordAuthenticator
implements PasswordAuthenticator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final IAuthenticationManager authManager;

    public UsernamePasswordAuthenticator(IAuthenticationManager authManager) {
        this.authManager = authManager;
    }

    public boolean authenticate(String username, String password, ServerSession session) {
        SshDaemonClient client = (SshDaemonClient)session.getAttribute(SshDaemonClient.KEY);
        if (client.getUser() != null) {
            this.log.info("{} has already authenticated!", (Object)username);
            return true;
        }
        UserModel user = this.authManager.authenticate(username = username.toLowerCase(Locale.US), password.toCharArray(), null);
        if (user != null) {
            client.setUser(user);
            return true;
        }
        this.log.warn("could not authenticate {} ({}) for SSH using the supplied password", (Object)username, (Object)client.getRemoteAddress());
        return false;
    }
}

