/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.commands;

import com.gitblit.manager.IGitblit;
import com.gitblit.models.PluginRegistry;
import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.transport.ssh.commands.DispatchCommand;
import com.gitblit.transport.ssh.commands.ListCommand;
import com.gitblit.transport.ssh.commands.ListFilterCommand;
import com.gitblit.transport.ssh.commands.SshCommand;
import com.gitblit.utils.FlipTable;
import com.gitblit.utils.StringUtils;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import ro.fortsoft.pf4j.ExtensionPoint;
import ro.fortsoft.pf4j.PluginDependency;
import ro.fortsoft.pf4j.PluginDescriptor;
import ro.fortsoft.pf4j.PluginState;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.Version;

@CommandMetaData(name="plugin", description="Plugin management commands", admin=true)
public class PluginDispatcher
extends DispatchCommand {
    @Override
    protected void setup() {
        this.register(ListPlugins.class);
        this.register(StartPlugin.class);
        this.register(StopPlugin.class);
        this.register(EnablePlugin.class);
        this.register(DisablePlugin.class);
        this.register(ShowPlugin.class);
        this.register(RefreshPlugins.class);
        this.register(AvailablePlugins.class);
        this.register(InstallPlugin.class);
        this.register(UpgradePlugin.class);
        this.register(UninstallPlugin.class);
    }

    @CommandMetaData(name="uninstall", aliases={"rm", "del"}, description="Uninstall a plugin")
    public static class UninstallPlugin
    extends PluginCommand {
        @Argument(index=0, required=true, metaVar="<ID>|<INDEX>", usage="the plugin to uninstall")
        protected String id;

        @Override
        public void run() throws BaseCommand.Failure {
            IGitblit gitblit = this.getContext().getGitblit();
            PluginWrapper pluginWrapper = this.getPlugin(this.id);
            if (pluginWrapper == null) {
                throw new BaseCommand.UnloggedFailure(String.format("Plugin %s is not installed!", this.id));
            }
            if (!gitblit.uninstallPlugin(pluginWrapper.getPluginId())) {
                throw new BaseCommand.UnloggedFailure(1, String.format("Failed to uninstall %s", pluginWrapper.getPluginId()));
            }
            this.stdout.println(String.format("Uninstalled %s", pluginWrapper.getPluginId()));
        }
    }

    @CommandMetaData(name="upgrade", description="Upgrade a plugin")
    public static class UpgradePlugin
    extends PluginCommand {
        @Argument(index=0, required=true, metaVar="<ID>|<INDEX>", usage="the plugin to upgrade")
        protected String id;
        @Option(name="--version", usage="The specific version to install")
        private String version;
        @Option(name="--noverify", usage="Disable checksum verification")
        private boolean disableChecksum;

        @Override
        public void run() throws BaseCommand.Failure {
            IGitblit gitblit = this.getContext().getGitblit();
            PluginWrapper pluginWrapper = this.getPlugin(this.id);
            if (pluginWrapper == null) {
                throw new BaseCommand.UnloggedFailure("Invalid plugin specified!");
            }
            PluginRegistry.PluginRelease pr = gitblit.lookupRelease(pluginWrapper.getPluginId(), this.version);
            if (pr == null) {
                throw new BaseCommand.UnloggedFailure(1, String.format("Plugin \"%s\" is not in the registry!", pluginWrapper.getPluginId()));
            }
            if (!StringUtils.isEmpty(pr.requires)) {
                boolean isValid;
                Version requires = Version.createVersion((String)pr.requires);
                Version system = gitblit.getSystemVersion();
                boolean bl = isValid = system.isZero() || system.atLeast(requires);
                if (!isValid) {
                    throw new BaseCommand.Failure(1, String.format("Plugin \"%s:%s\" requires Gitblit %s", pluginWrapper.getPluginId(), pr.version, pr.requires));
                }
            }
            try {
                if (!gitblit.upgradePlugin(pluginWrapper.getPluginId(), pr.url, !this.disableChecksum)) {
                    throw new BaseCommand.UnloggedFailure(1, String.format("Failed to upgrade %s", pluginWrapper.getPluginId()));
                }
                this.stdout.println(String.format("Upgraded %s", pluginWrapper.getPluginId()));
            }
            catch (IOException e) {
                this.log.error("Failed to upgrade " + pluginWrapper.getPluginId(), (Throwable)e);
                throw new BaseCommand.UnloggedFailure(1, String.format("Failed to upgrade %s", pluginWrapper.getPluginId()), e);
            }
        }
    }

    @CommandMetaData(name="install", description="Download and installs a plugin")
    public static class InstallPlugin
    extends SshCommand {
        @Argument(index=0, required=true, metaVar="<URL>|<ID>", usage="the id or the url of the plugin to download and install")
        protected String urlOrId;
        @Option(name="--version", usage="The specific version to install")
        private String version;
        @Option(name="--noverify", usage="Disable checksum verification")
        private boolean disableChecksum;

        @Override
        public void run() throws BaseCommand.Failure {
            block8: {
                IGitblit gitblit = this.getContext().getGitblit();
                try {
                    String ulc = this.urlOrId.toLowerCase();
                    if (ulc.startsWith("http://") || ulc.startsWith("https://")) {
                        if (gitblit.installPlugin(this.urlOrId, !this.disableChecksum)) {
                            this.stdout.println(String.format("Installed %s", this.urlOrId));
                            break block8;
                        }
                        throw new BaseCommand.UnloggedFailure(1, String.format("Failed to install %s", this.urlOrId));
                    }
                    PluginRegistry.PluginRelease pr = gitblit.lookupRelease(this.urlOrId, this.version);
                    if (pr == null) {
                        throw new BaseCommand.UnloggedFailure(1, String.format("Plugin \"%s\" is not in the registry!", this.urlOrId));
                    }
                    if (!StringUtils.isEmpty(pr.requires)) {
                        boolean isValid;
                        Version requires = Version.createVersion((String)pr.requires);
                        Version system = gitblit.getSystemVersion();
                        boolean bl = isValid = system.isZero() || system.atLeast(requires);
                        if (!isValid) {
                            String msg = String.format("Plugin \"%s:%s\" requires Gitblit %s", this.urlOrId, pr.version, pr.requires);
                            throw new BaseCommand.UnloggedFailure(1, msg);
                        }
                    }
                    if (gitblit.installPlugin(pr.url, !this.disableChecksum)) {
                        this.stdout.println(String.format("Installed %s", this.urlOrId));
                        break block8;
                    }
                    throw new BaseCommand.UnloggedFailure(1, String.format("Failed to install %s", this.urlOrId));
                }
                catch (IOException e) {
                    this.log.error("Failed to install " + this.urlOrId, (Throwable)e);
                    throw new BaseCommand.UnloggedFailure(1, String.format("Failed to install %s", this.urlOrId), e);
                }
            }
        }
    }

    @CommandMetaData(name="available", description="List the available plugins")
    public static class AvailablePlugins
    extends ListFilterCommand<PluginRegistry.PluginRegistration> {
        @Option(name="--refresh", aliases={"-r"}, usage="refresh the plugin registry")
        protected boolean refresh;
        @Option(name="--updates", aliases={"-u"}, usage="show available updates")
        protected boolean updates;
        @Option(name="--noverify", usage="Disable checksum verification")
        private boolean disableChecksum;

        @Override
        protected List<PluginRegistry.PluginRegistration> getItems() throws BaseCommand.UnloggedFailure {
            IGitblit gitblit = this.getContext().getGitblit();
            if (this.refresh) {
                gitblit.refreshRegistry(!this.disableChecksum);
            }
            List<PluginRegistry.PluginRegistration> list = this.updates ? gitblit.getRegisteredPlugins(PluginRegistry.InstallState.UPDATE_AVAILABLE) : gitblit.getRegisteredPlugins();
            return list;
        }

        @Override
        protected boolean matches(String filter, PluginRegistry.PluginRegistration t) {
            return t.id.matches(filter) || t.description != null && t.description.matches(filter);
        }

        @Override
        protected void asTable(List<PluginRegistry.PluginRegistration> list) {
            String[] h;
            String[] headers = this.verbose ? (h = new String[]{"Id", "Description", "Installed", "Current", "Requires", "State", "Registry"}) : (h = new String[]{"Id", "Installed", "Current", "Requires", "State"});
            Version system = this.getContext().getGitblit().getSystemVersion();
            Object[][] data = new Object[list.size()][];
            for (int i = 0; i < list.size(); ++i) {
                PluginRegistry.PluginRegistration p = list.get(i);
                PluginRegistry.PluginRelease curr = p.getCurrentRelease(system);
                if (curr == null) {
                    curr = new PluginRegistry.PluginRelease();
                }
                data[i] = this.verbose ? new Object[]{p.id, p.description, p.installedRelease, curr.version, curr.requires, p.getInstallState(system), p.registry} : new Object[]{p.id, p.installedRelease, curr.version, curr.requires, p.getInstallState(system)};
            }
            this.stdout.println(FlipTable.of(headers, data, FlipTable.Borders.BODY_HCOLS));
        }

        @Override
        protected void asTabbed(List<PluginRegistry.PluginRegistration> list) {
            Version system = this.getContext().getGitblit().getSystemVersion();
            for (PluginRegistry.PluginRegistration p : list) {
                PluginRegistry.PluginRelease curr = p.getCurrentRelease(system);
                if (curr == null) {
                    curr = new PluginRegistry.PluginRelease();
                }
                if (this.verbose) {
                    this.outTabbed(new Object[]{p.id, p.description, p.installedRelease, curr.version, curr.requires, p.getInstallState(system), p.provider, p.registry});
                    continue;
                }
                this.outTabbed(new Object[]{p.id, p.installedRelease, curr.version, curr.requires, p.getInstallState(system)});
            }
        }
    }

    @CommandMetaData(name="refresh", description="Refresh the plugin registry data")
    public static class RefreshPlugins
    extends SshCommand {
        @Option(name="--noverify", usage="Disable checksum verification")
        private boolean disableChecksum;

        @Override
        public void run() throws BaseCommand.Failure {
            IGitblit gitblit = this.getContext().getGitblit();
            gitblit.refreshRegistry(!this.disableChecksum);
        }
    }

    @CommandMetaData(name="show", description="Show the details of a plugin")
    public static class ShowPlugin
    extends PluginCommand {
        @Argument(index=0, required=true, metaVar="<ID>|<INDEX>", usage="the plugin to show")
        protected String id;

        @Override
        public void run() throws BaseCommand.Failure {
            IGitblit gitblit = this.getContext().getGitblit();
            PluginWrapper pw = this.getPlugin(this.id);
            if (pw == null) {
                PluginRegistry.PluginRegistration registration = gitblit.lookupPlugin(this.id);
                if (registration == null) {
                    throw new BaseCommand.Failure(1, String.format("Unknown plugin %s", this.id));
                }
                this.show(registration);
            } else {
                this.show(pw);
            }
        }

        protected String buildFieldTable(PluginWrapper pw, PluginRegistry.PluginRegistration reg) {
            String projectUrl;
            PluginRegistry.PluginRelease current;
            Version system = this.getContext().getGitblit().getSystemVersion();
            PluginRegistry.PluginRelease pluginRelease = current = reg == null ? null : reg.getCurrentRelease(system);
            if (current == null) {
                current = new PluginRegistry.PluginRelease();
                current.version = "";
                current.requires = "";
            }
            String id = pw == null ? reg.id : pw.getPluginId();
            String description = reg == null ? pw.getDescriptor().getPluginDescription() : reg.description;
            String version = pw == null ? current.version : pw.getDescriptor().getVersion().toString();
            String requires = pw == null ? current.requires : pw.getDescriptor().getRequires().toString();
            String provider = pw == null ? reg.provider : pw.getDescriptor().getProvider();
            String registry = reg == null ? "" : reg.registry;
            String path = pw == null ? "" : pw.getPluginPath();
            String string = projectUrl = reg == null ? "" : reg.projectUrl;
            String state = pw == null ? PluginRegistry.InstallState.NOT_INSTALLED.toString() : (reg == null ? Joiner.on((String)", ").join((Object)PluginRegistry.InstallState.INSTALLED, (Object)pw.getPluginState(), new Object[0]) : Joiner.on((String)", ").join((Object)reg.getInstallState(system), (Object)pw.getPluginState(), new Object[0]));
            StringBuilder sb = new StringBuilder();
            sb.append("ID          : ").append(id).append('\n');
            sb.append("Version     : ").append(version).append('\n');
            sb.append("Requires    : ").append(requires).append('\n');
            sb.append("State       : ").append(state).append('\n');
            sb.append("Path        : ").append(path).append('\n');
            sb.append('\n');
            sb.append("Description : ").append(description).append('\n');
            sb.append("Provider    : ").append(provider).append('\n');
            sb.append("Project URL : ").append(projectUrl).append('\n');
            sb.append("Registry    : ").append(registry).append('\n');
            return sb.toString();
        }

        protected String buildReleaseTable(PluginRegistry.PluginRegistration reg) {
            String releaseTable;
            List<PluginRegistry.PluginRelease> releases = reg.releases;
            Collections.sort(releases);
            if (releases.isEmpty()) {
                releaseTable = "(empty)";
            } else {
                String[] headers = new String[]{"Version", "Date", "Requires"};
                Object[][] data = new Object[releases.size()][];
                for (int i = 0; i < releases.size(); ++i) {
                    PluginRegistry.PluginRelease release = releases.get(i);
                    data[i] = new Object[]{(release.version.equals(reg.installedRelease) ? ">" : " ") + release.version, release.date, release.requires};
                }
                releaseTable = FlipTable.of(headers, data, FlipTable.Borders.COLS);
            }
            return releaseTable;
        }

        protected void show(PluginRegistry.PluginRegistration reg) {
            String fields = this.buildFieldTable(null, reg);
            String releases = this.buildReleaseTable(reg);
            String[] headers = new String[]{reg.id};
            Object[][] data = new Object[][]{{fields}, {"RELEASES"}, {releases}};
            this.stdout.println(FlipTable.of(headers, data));
        }

        protected void show(PluginWrapper pw) {
            String dependencies;
            String extensions;
            IGitblit gitblit = this.getContext().getGitblit();
            PluginRegistry.PluginRegistration reg = gitblit.lookupPlugin(pw.getPluginId());
            String fields = this.buildFieldTable(pw, reg);
            StringBuilder sb = new StringBuilder();
            List<Class<?>> exts = gitblit.getExtensionClasses(pw.getPluginId());
            if (exts.isEmpty()) {
                extensions = "(empty)";
            } else {
                StringBuilder description = new StringBuilder();
                for (int i = 0; i < exts.size(); ++i) {
                    Class<?> ext = exts.get(i);
                    if (ext.isAnnotationPresent(CommandMetaData.class)) {
                        CommandMetaData meta = ext.getAnnotation(CommandMetaData.class);
                        description.append(meta.name());
                        if (meta.description().length() > 0) {
                            description.append(": ").append(meta.description());
                        }
                        description.append('\n');
                    }
                    description.append(ext.getName()).append("\n  \u2514 ");
                    description.append(this.getExtensionPoint(ext).getName());
                    description.append("\n\n");
                }
                extensions = description.toString();
            }
            sb.setLength(0);
            List deps = pw.getDescriptor().getDependencies();
            if (deps.isEmpty()) {
                dependencies = "(empty)";
            } else {
                String[] headers = new String[]{"Id", "Version"};
                Object[][] data = new Object[deps.size()][];
                for (int i = 0; i < deps.size(); ++i) {
                    PluginDependency dep = (PluginDependency)deps.get(i);
                    data[i] = new Object[]{dep.getPluginId(), dep.getPluginVersion()};
                }
                dependencies = FlipTable.of(headers, data, FlipTable.Borders.COLS);
            }
            String releases = reg == null ? "(empty)" : this.buildReleaseTable(reg);
            String[] headers = new String[]{pw.getPluginId()};
            Object[][] data = new Object[][]{{fields}, {"EXTENSIONS"}, {extensions}, {"DEPENDENCIES"}, {dependencies}, {"RELEASES"}, {releases}};
            this.stdout.println(FlipTable.of(headers, data));
        }

        protected Class<?> getExtensionPoint(Class<?> clazz) {
            Class<?> superClass = clazz.getSuperclass();
            if (ExtensionPoint.class.isAssignableFrom(superClass)) {
                return superClass;
            }
            return this.getExtensionPoint(superClass);
        }
    }

    @CommandMetaData(name="disable", description="Disable a plugin")
    public static class DisablePlugin
    extends PluginCommand {
        @Argument(index=0, required=true, metaVar="<ID>|<INDEX>", usage="the plugin to disable")
        protected String id;

        @Override
        public void run() throws BaseCommand.Failure {
            IGitblit gitblit = this.getContext().getGitblit();
            PluginWrapper pluginWrapper = this.getPlugin(this.id);
            if (pluginWrapper == null) {
                throw new BaseCommand.UnloggedFailure("Invalid plugin specified!");
            }
            if (!gitblit.disablePlugin(pluginWrapper.getPluginId())) {
                throw new BaseCommand.UnloggedFailure(1, String.format("Failed to disable %s", pluginWrapper.getPluginId()));
            }
            this.stdout.println(String.format("Disabled %s", pluginWrapper.getPluginId()));
        }
    }

    @CommandMetaData(name="enable", description="Enable a plugin")
    public static class EnablePlugin
    extends PluginCommand {
        @Argument(index=0, required=true, metaVar="<ID>|<INDEX>", usage="the plugin to enable")
        protected String id;

        @Override
        public void run() throws BaseCommand.Failure {
            IGitblit gitblit = this.getContext().getGitblit();
            PluginWrapper pluginWrapper = this.getPlugin(this.id);
            if (pluginWrapper == null) {
                throw new BaseCommand.UnloggedFailure("Invalid plugin specified!");
            }
            if (!gitblit.enablePlugin(pluginWrapper.getPluginId())) {
                throw new BaseCommand.UnloggedFailure(1, String.format("Failed to enable %s", pluginWrapper.getPluginId()));
            }
            this.stdout.println(String.format("Enabled %s", pluginWrapper.getPluginId()));
        }
    }

    @CommandMetaData(name="stop", description="Stop a plugin")
    public static class StopPlugin
    extends PluginCommand {
        @Argument(index=0, required=true, metaVar="ALL|<ID>|<INDEX>", usage="the plugin to stop")
        protected String id;

        @Override
        public void run() throws BaseCommand.Failure {
            IGitblit gitblit = this.getContext().getGitblit();
            if (this.id.equalsIgnoreCase("ALL")) {
                gitblit.stopPlugins();
                this.stdout.println("All plugins stopped");
            } else {
                PluginWrapper pluginWrapper = this.getPlugin(this.id);
                if (pluginWrapper == null) {
                    throw new BaseCommand.UnloggedFailure(String.format("Plugin %s is not installed!", this.id));
                }
                PluginState state = gitblit.stopPlugin(pluginWrapper.getPluginId());
                if (PluginState.STOPPED.equals((Object)state)) {
                    this.stdout.println(String.format("Stopped %s", pluginWrapper.getPluginId()));
                } else {
                    throw new BaseCommand.UnloggedFailure(1, String.format("Failed to stop %s", pluginWrapper.getPluginId()));
                }
            }
        }
    }

    @CommandMetaData(name="start", description="Start a plugin")
    public static class StartPlugin
    extends PluginCommand {
        @Argument(index=0, required=true, metaVar="ALL|<ID>|<INDEX>", usage="the plugin to start")
        protected String id;

        @Override
        public void run() throws BaseCommand.Failure {
            IGitblit gitblit = this.getContext().getGitblit();
            if (this.id.equalsIgnoreCase("ALL")) {
                gitblit.startPlugins();
                this.stdout.println("All plugins started");
            } else {
                PluginWrapper pluginWrapper = this.getPlugin(this.id);
                if (pluginWrapper == null) {
                    throw new BaseCommand.UnloggedFailure(String.format("Plugin %s is not installed!", this.id));
                }
                PluginState state = gitblit.startPlugin(pluginWrapper.getPluginId());
                if (PluginState.STARTED.equals((Object)state)) {
                    this.stdout.println(String.format("Started %s", pluginWrapper.getPluginId()));
                } else {
                    throw new BaseCommand.UnloggedFailure(1, String.format("Failed to start %s", pluginWrapper.getPluginId()));
                }
            }
        }
    }

    static abstract class PluginCommand
    extends SshCommand {
        PluginCommand() {
        }

        protected PluginWrapper getPlugin(String id) throws BaseCommand.Failure {
            PluginWrapper pluginWrapper;
            block4: {
                IGitblit gitblit = this.getContext().getGitblit();
                pluginWrapper = null;
                try {
                    int index = Integer.parseInt(id);
                    List<PluginWrapper> plugins2 = gitblit.getPlugins();
                    if (index > plugins2.size()) {
                        throw new BaseCommand.UnloggedFailure(1, "Invalid plugin index specified!");
                    }
                    pluginWrapper = plugins2.get(index - 1);
                }
                catch (NumberFormatException e) {
                    pluginWrapper = gitblit.getPlugin(id);
                    if (pluginWrapper != null) break block4;
                    PluginRegistry.PluginRegistration reg = gitblit.lookupPlugin(id);
                    if (reg == null) {
                        throw new BaseCommand.UnloggedFailure("Invalid plugin specified!");
                    }
                    pluginWrapper = gitblit.getPlugin(reg.id);
                }
            }
            return pluginWrapper;
        }
    }

    @CommandMetaData(name="list", aliases={"ls"}, description="List plugins")
    public static class ListPlugins
    extends ListCommand<PluginWrapper> {
        @Override
        protected List<PluginWrapper> getItems() throws BaseCommand.UnloggedFailure {
            IGitblit gitblit = this.getContext().getGitblit();
            List<PluginWrapper> list = gitblit.getPlugins();
            return list;
        }

        @Override
        protected void asTable(List<PluginWrapper> list) {
            String[] h;
            String[] headers = this.verbose ? (h = new String[]{"#", "Id", "Description", "Version", "Requires", "State", "Path"}) : (h = new String[]{"#", "Id", "Version", "State", "Path"});
            Object[][] data = new Object[list.size()][];
            for (int i = 0; i < list.size(); ++i) {
                PluginWrapper p = list.get(i);
                PluginDescriptor d = p.getDescriptor();
                data[i] = this.verbose ? new Object[]{"" + (i + 1), d.getPluginId(), d.getPluginDescription(), d.getVersion(), d.getRequires(), p.getPluginState(), p.getPluginPath()} : new Object[]{"" + (i + 1), d.getPluginId(), d.getVersion(), p.getPluginState(), p.getPluginPath()};
            }
            this.stdout.println(FlipTable.of(headers, data, FlipTable.Borders.BODY_HCOLS));
        }

        @Override
        protected void asTabbed(List<PluginWrapper> list) {
            for (PluginWrapper pw : list) {
                PluginDescriptor d = pw.getDescriptor();
                if (this.verbose) {
                    this.outTabbed(d.getPluginId(), d.getPluginDescription(), d.getVersion(), d.getRequires(), pw.getPluginState(), pw.getPluginPath());
                    continue;
                }
                this.outTabbed(d.getPluginId(), d.getVersion(), pw.getPluginState(), pw.getPluginPath());
            }
        }
    }
}

