/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.commands;

import com.gitblit.manager.IGitblit;
import com.gitblit.transport.ssh.SshDaemonClient;
import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.transport.ssh.commands.DispatchCommand;
import com.gitblit.transport.ssh.commands.PluginDispatcher;
import com.gitblit.transport.ssh.commands.SshCommandContext;
import com.gitblit.transport.ssh.commands.VersionCommand;
import com.gitblit.transport.ssh.git.GitDispatcher;
import com.gitblit.transport.ssh.keys.KeysDispatcher;
import com.gitblit.utils.WorkQueue;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginWrapper;

@CommandMetaData(name="")
class RootDispatcher
extends DispatchCommand {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public RootDispatcher(IGitblit gitblit, SshDaemonClient client, String cmdLine, WorkQueue workQueue) {
        this.setContext(new SshCommandContext(gitblit, client, cmdLine));
        this.setWorkQueue(workQueue);
        this.register(VersionCommand.class);
        this.register(GitDispatcher.class);
        this.register(KeysDispatcher.class);
        this.register(PluginDispatcher.class);
        List<DispatchCommand> exts = gitblit.getExtensions(DispatchCommand.class);
        for (DispatchCommand ext : exts) {
            Class<?> extClass = ext.getClass();
            PluginWrapper wrapper = gitblit.whichPlugin(extClass);
            String plugin = wrapper.getDescriptor().getPluginId();
            CommandMetaData meta = extClass.getAnnotation(CommandMetaData.class);
            this.log.debug("Dispatcher {} is loaded from plugin {}", (Object)meta.name(), (Object)plugin);
            this.register(ext);
        }
    }

    @Override
    protected final void setup() {
    }
}

