/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.commands;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IGitblit;
import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.sshd.server.Environment;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SshCommand
extends BaseCommand {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected PrintWriter stdout;
    protected PrintWriter stderr;

    @Override
    public void start(Environment env) throws IOException {
        this.startThread(new BaseCommand.CommandRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                SshCommand.this.parseCommandLine();
                SshCommand.this.stdout = BaseCommand.toPrintWriter(SshCommand.this.out);
                SshCommand.this.stderr = BaseCommand.toPrintWriter(SshCommand.this.err);
                try {
                    SshCommand.this.run();
                }
                finally {
                    SshCommand.this.stdout.flush();
                    SshCommand.this.stderr.flush();
                }
            }
        });
    }

    protected String getHostname() {
        IGitblit gitblit = this.getContext().getGitblit();
        String host = null;
        String url = gitblit.getSettings().getString("web.canonicalUrl", "https://localhost:8443");
        if (url != null) {
            try {
                host = new URL(url).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty(host)) {
            host = SystemReader.getInstance().getHostname();
        }
        return host;
    }

    protected String getRepositoryUrl(String repository) {
        int port;
        int displayPort;
        String username = this.getContext().getClient().getUsername();
        IStoredSettings settings = this.getContext().getGitblit().getSettings();
        String displayHostname = settings.getString("git.sshAdvertisedHost", "");
        if (displayHostname.isEmpty()) {
            displayHostname = this.getHostname();
        }
        if ((displayPort = settings.getInteger("git.sshAdvertisedPort", port = settings.getInteger("git.sshPort", 0))) == 22) {
            return MessageFormat.format("{0}@{1}/{2}.git", username, displayHostname, repository);
        }
        return MessageFormat.format("ssh://{0}@{1}:{2,number,0}/{3}", username, displayHostname, displayPort, repository);
    }

    protected abstract void run() throws BaseCommand.Failure, Exception;
}

