/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.commands;

import com.gitblit.manager.IGitblit;
import com.gitblit.transport.ssh.SshDaemonClient;
import com.gitblit.transport.ssh.commands.DispatchCommand;
import com.gitblit.transport.ssh.commands.RootDispatcher;
import com.gitblit.utils.WorkQueue;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommandFactory
implements CommandFactory {
    private static final Logger logger = LoggerFactory.getLogger(SshCommandFactory.class);
    private final WorkQueue workQueue;
    private final IGitblit gitblit;
    private final ScheduledExecutorService startExecutor;
    private final ExecutorService destroyExecutor;

    public SshCommandFactory(IGitblit gitblit, WorkQueue workQueue) {
        this.gitblit = gitblit;
        this.workQueue = workQueue;
        int threads = gitblit.getSettings().getInteger("git.sshCommandStartThreads", 2);
        this.startExecutor = workQueue.createQueue(threads, "SshCommandStart");
        this.destroyExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("SshCommandDestroy-%s").setDaemon(true).build());
    }

    public void stop() {
        this.destroyExecutor.shutdownNow();
    }

    public RootDispatcher createRootDispatcher(SshDaemonClient client, String commandLine) {
        return new RootDispatcher(this.gitblit, client, commandLine, this.workQueue);
    }

    public Command createCommand(String commandLine) {
        return new Trampoline(commandLine);
    }

    public static String[] split(String commandLine) {
        ArrayList<String> list = new ArrayList<String>();
        boolean inquote = false;
        boolean inDblQuote = false;
        StringBuilder r = new StringBuilder();
        int ip = 0;
        block6: while (ip < commandLine.length()) {
            char b = commandLine.charAt(ip++);
            switch (b) {
                case '\t': 
                case ' ': {
                    if (inquote || inDblQuote) {
                        r.append(b);
                        continue block6;
                    }
                    if (r.length() <= 0) continue block6;
                    list.add(r.toString());
                    r = new StringBuilder();
                    continue block6;
                }
                case '\"': {
                    if (inquote) {
                        r.append(b);
                        continue block6;
                    }
                    inDblQuote = !inDblQuote;
                    continue block6;
                }
                case '\'': {
                    if (inDblQuote) {
                        r.append(b);
                        continue block6;
                    }
                    inquote = !inquote;
                    continue block6;
                }
                case '\\': {
                    if (inquote || ip == commandLine.length()) {
                        r.append(b);
                        continue block6;
                    }
                    r.append(commandLine.charAt(ip++));
                    continue block6;
                }
            }
            r.append(b);
        }
        if (r.length() > 0) {
            list.add(r.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private class Trampoline
    implements Command,
    SessionAware {
        private final String[] argv;
        private ServerSession session;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback exit;
        private Environment env;
        private String cmdLine;
        private DispatchCommand cmd;
        private final AtomicBoolean logged;
        private final AtomicReference<Future<?>> task;

        Trampoline(String line) {
            if (line.startsWith("git-")) {
                line = "git " + line;
            }
            this.cmdLine = line;
            this.argv = SshCommandFactory.split(line);
            this.logged = new AtomicBoolean();
            this.task = Atomics.newReference();
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.exit = callback;
        }

        public void start(Environment env) throws IOException {
            this.env = env;
            this.task.set(SshCommandFactory.this.startExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Trampoline.this.onStart();
                    }
                    catch (Exception e) {
                        logger.warn("Cannot start command ", (Throwable)e);
                    }
                }

                public String toString() {
                    return "start (user " + Trampoline.this.session.getUsername() + ")";
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onStart() throws IOException {
            Trampoline trampoline = this;
            synchronized (trampoline) {
                SshDaemonClient client = (SshDaemonClient)this.session.getAttribute(SshDaemonClient.KEY);
                try {
                    this.cmd = SshCommandFactory.this.createRootDispatcher(client, this.cmdLine);
                    this.cmd.setArguments(this.argv);
                    this.cmd.setInputStream(this.in);
                    this.cmd.setOutputStream(this.out);
                    this.cmd.setErrorStream(this.err);
                    this.cmd.setExitCallback(new ExitCallback(){

                        public void onExit(int rc, String exitMessage) {
                            Trampoline.this.exit.onExit(Trampoline.this.translateExit(rc), exitMessage);
                            Trampoline.this.log(rc);
                        }

                        public void onExit(int rc) {
                            Trampoline.this.exit.onExit(Trampoline.this.translateExit(rc));
                            Trampoline.this.log(rc);
                        }
                    });
                    this.cmd.start(this.env);
                }
                finally {
                    client = null;
                }
            }
        }

        private int translateExit(int rc) {
            switch (rc) {
                case 0x40000003: {
                    return 1;
                }
                case 0x40000001: {
                    return 15;
                }
                case 0x40000002: {
                    return 127;
                }
            }
            return rc;
        }

        private void log(int rc) {
            if (this.logged.compareAndSet(false, true)) {
                logger.info("onExecute: {} exits with: {}", (Object)this.cmd.getClass().getSimpleName(), (Object)rc);
            }
        }

        public void destroy() {
            Future future = this.task.getAndSet(null);
            if (future != null) {
                future.cancel(true);
                SshCommandFactory.this.destroyExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Trampoline.this.onDestroy();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDestroy() {
            Trampoline trampoline = this;
            synchronized (trampoline) {
                if (this.cmd != null) {
                    try {
                        this.cmd.destroy();
                    }
                    finally {
                        this.cmd = null;
                    }
                }
            }
        }
    }
}

