/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.git;

import com.gitblit.git.GitblitReceivePackFactory;
import com.gitblit.git.GitblitUploadPackFactory;
import com.gitblit.git.RepositoryResolver;
import com.gitblit.manager.IGitblit;
import com.gitblit.transport.ssh.SshDaemonClient;
import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.transport.ssh.commands.DispatchCommand;
import com.gitblit.transport.ssh.commands.SshCommandContext;
import com.gitblit.transport.ssh.git.BaseGitCommand;
import com.gitblit.transport.ssh.git.GarbageCollectionCommand;
import com.gitblit.transport.ssh.git.Receive;
import com.gitblit.transport.ssh.git.Upload;

@CommandMetaData(name="git", description="Git repository commands")
public class GitDispatcher
extends DispatchCommand {
    protected RepositoryResolver<SshDaemonClient> repositoryResolver;
    protected GitblitUploadPackFactory<SshDaemonClient> uploadPackFactory;
    protected GitblitReceivePackFactory<SshDaemonClient> receivePackFactory;

    @Override
    public void setContext(SshCommandContext context) {
        super.setContext(context);
        IGitblit gitblit = context.getGitblit();
        this.repositoryResolver = new RepositoryResolver(gitblit);
        this.uploadPackFactory = new GitblitUploadPackFactory(gitblit);
        this.receivePackFactory = new GitblitReceivePackFactory(gitblit);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.repositoryResolver = null;
        this.receivePackFactory = null;
        this.uploadPackFactory = null;
    }

    @Override
    protected void setup() {
        this.register(Upload.class);
        this.register(Receive.class);
        this.register(GarbageCollectionCommand.class);
    }

    @Override
    protected void provideStateTo(BaseCommand cmd) {
        super.provideStateTo(cmd);
        BaseGitCommand a = (BaseGitCommand)cmd;
        a.setRepositoryResolver(this.repositoryResolver);
        a.setUploadPackFactory(this.uploadPackFactory);
        a.setReceivePackFactory(this.receivePackFactory);
    }
}

