/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.git;

import com.gitblit.transport.ssh.SshKey;
import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.transport.ssh.git.BaseGitCommand;
import org.eclipse.jgit.transport.ReceivePack;

@CommandMetaData(name="git-receive-pack", description="Receives pushes from a client", hidden=true)
public class Receive
extends BaseGitCommand {
    @Override
    protected void runImpl() throws BaseCommand.Failure {
        SshKey key = this.getContext().getClient().getKey();
        if (key != null && !key.canPush()) {
            throw new BaseCommand.Failure(1, "Sorry, your SSH public key is not allowed to push changes!");
        }
        try {
            ReceivePack rp = this.receivePackFactory.create((Object)this.getContext().getClient(), this.repo);
            rp.receive(this.in, this.out, null);
        }
        catch (Exception e) {
            throw new BaseCommand.Failure(1, "fatal: Cannot receive pack: ", e);
        }
    }
}

