/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.git;

import com.gitblit.transport.ssh.SshKey;
import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.transport.ssh.git.BaseGitCommand;
import org.eclipse.jgit.transport.UploadPack;

@CommandMetaData(name="git-upload-pack", description="Sends packs to a client for clone and fetch", hidden=true)
public class Upload
extends BaseGitCommand {
    @Override
    protected void runImpl() throws BaseCommand.Failure {
        try {
            SshKey key = this.getContext().getClient().getKey();
            if (key != null && !key.canClone()) {
                throw new BaseCommand.Failure(1, "Sorry, your SSH public key is not allowed to clone!");
            }
            UploadPack up = this.uploadPackFactory.create((Object)this.getContext().getClient(), this.repo);
            up.upload(this.in, this.out, null);
        }
        catch (Exception e) {
            throw new BaseCommand.Failure(1, "fatal: Cannot upload pack: ", e);
        }
    }
}

