/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.keys;

import com.gitblit.Constants;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.transport.ssh.SshKey;
import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.transport.ssh.commands.DispatchCommand;
import com.gitblit.transport.ssh.commands.SshCommand;
import com.gitblit.transport.ssh.commands.UsageExample;
import com.gitblit.transport.ssh.keys.BaseKeyCommand;
import com.gitblit.utils.FlipTable;
import com.gitblit.utils.StringUtils;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMetaData(name="keys", description="SSH public key management commands")
public class KeysDispatcher
extends DispatchCommand {
    @Override
    protected void setup() {
        IPublicKeyManager km = this.getContext().getGitblit().getPublicKeyManager();
        UserModel user = this.getContext().getClient().getUser();
        if (km != null && km.supportsWritingKeys(user)) {
            this.register(AddKey.class);
            this.register(RemoveKey.class);
        }
        this.register(ListKeys.class);
        this.register(WhichKey.class);
        if (km != null && km.supportsCommentChanges(user)) {
            this.register(CommentKey.class);
        }
        if (km != null && km.supportsPermissionChanges(user)) {
            this.register(PermissionKey.class);
        }
    }

    @CommandMetaData(name="permission", description="Set the permission of an SSH public key")
    @UsageExample(syntax="${cmd} 3 RW", description="Set the permission for key #3 to PUSH (PW)")
    public static class PermissionKey
    extends SshCommand {
        @Argument(index=0, metaVar="INDEX", usage="the key index", required=true)
        private int index;
        @Argument(index=1, metaVar="PERMISSION", usage="the new permission", required=true)
        private String value;

        @Override
        public void run() throws BaseCommand.Failure {
            String username = this.getContext().getClient().getUsername();
            IPublicKeyManager keyManager = this.getContext().getGitblit().getPublicKeyManager();
            List<SshKey> keys = keyManager.getKeys(username);
            if (this.index > keys.size()) {
                throw new BaseCommand.UnloggedFailure(1, "Invalid key index!");
            }
            SshKey key = keys.get(this.index - 1);
            Constants.AccessPermission permission = Constants.AccessPermission.fromCode(this.value);
            if (permission.exceeds(Constants.AccessPermission.NONE)) {
                try {
                    key.setPermission(permission);
                }
                catch (IllegalArgumentException e) {
                    throw new BaseCommand.Failure(1, e.getMessage());
                }
            }
            if (!keyManager.addKey(username, key)) {
                throw new BaseCommand.Failure(1, String.format("Failed to update the comment for key #%d!", this.index));
            }
            this.stdout.println(String.format("Updated the permission for key #%d.", this.index));
        }
    }

    @CommandMetaData(name="comment", description="Set the comment for an SSH public key")
    @UsageExample(syntax="${cmd} 3 Home workstation", description="Set the comment for key #3")
    public static class CommentKey
    extends SshCommand {
        @Argument(index=0, metaVar="INDEX", usage="the key index", required=true)
        private int index;
        @Argument(index=1, metaVar="COMMENT", usage="the new comment", required=true)
        private List<String> values = new ArrayList<String>();

        @Override
        public void run() throws BaseCommand.Failure {
            String username = this.getContext().getClient().getUsername();
            IPublicKeyManager keyManager = this.getContext().getGitblit().getPublicKeyManager();
            List<SshKey> keys = keyManager.getKeys(username);
            if (this.index > keys.size()) {
                throw new BaseCommand.UnloggedFailure(1, "Invalid key index!");
            }
            String comment = Joiner.on((String)" ").join(this.values);
            SshKey key = keys.get(this.index - 1);
            key.setComment(comment);
            if (!keyManager.addKey(username, key)) {
                throw new BaseCommand.Failure(1, String.format("Failed to update the comment for key #%d!", this.index));
            }
            this.stdout.println(String.format("Updated the comment for key #%d.", this.index));
        }
    }

    @CommandMetaData(name="which", description="Display the SSH public key used for this session")
    public static class WhichKey
    extends SshCommand {
        @Option(name="-L", usage="list complete public key parameters")
        private boolean showRaw;

        @Override
        public void run() throws BaseCommand.UnloggedFailure {
            SshKey key = this.getContext().getClient().getKey();
            if (key == null) {
                throw new BaseCommand.UnloggedFailure(1, "You have not authenticated with an SSH public key.");
            }
            if (this.showRaw) {
                this.stdout.println(key.getRawData());
            } else {
                String username = this.getContext().getClient().getUsername();
                List<SshKey> keys = this.getContext().getGitblit().getPublicKeyManager().getKeys(username);
                int index = 0;
                for (int i = 0; i < keys.size(); ++i) {
                    if (!key.equals(keys.get(i))) continue;
                    index = i + 1;
                    break;
                }
                this.asTable(index, key);
            }
        }

        protected void asTable(int index, SshKey key) {
            String[] headers = new String[]{"#", "Fingerprint", "Comment", "Permission", "Type"};
            Object[][] data = new Object[][]{{index, key.getFingerprint(), key.getComment(), key.getPermission(), key.getAlgorithm()}};
            this.stdout.println(FlipTable.of(headers, data, FlipTable.Borders.BODY_HCOLS));
        }
    }

    @CommandMetaData(name="list", aliases={"ls"}, description="List your registered SSH public keys")
    public static class ListKeys
    extends SshCommand {
        @Option(name="-L", usage="list complete public key parameters")
        private boolean showRaw;

        @Override
        public void run() {
            IPublicKeyManager keyManager = this.getContext().getGitblit().getPublicKeyManager();
            String username = this.getContext().getClient().getUsername();
            List<SshKey> keys = keyManager.getKeys(username);
            if (this.showRaw) {
                this.asRaw(keys);
            } else {
                this.asTable(keys);
            }
        }

        protected void asRaw(List<SshKey> keys) {
            if (keys == null) {
                return;
            }
            for (SshKey key : keys) {
                this.stdout.println(key.getRawData());
            }
        }

        protected void asTable(List<SshKey> keys) {
            String[] headers = new String[]{"#", "Fingerprint", "Comment", "Permission", "Type"};
            int len = keys == null ? 0 : keys.size();
            Object[][] data = new Object[len][];
            for (int i = 0; i < len; ++i) {
                SshKey k = keys.get(i);
                data[i] = new Object[]{i + 1, k.getFingerprint(), k.getComment(), k.getPermission(), k.getAlgorithm()};
            }
            this.stdout.println(FlipTable.of(headers, data, FlipTable.Borders.BODY_HCOLS));
        }
    }

    @CommandMetaData(name="remove", aliases={"rm"}, description="Remove an SSH public key from your account")
    @UsageExample(syntax="${cmd} 2", description="Remove the SSH key identified as #2 in `keys list`")
    public static class RemoveKey
    extends BaseKeyCommand {
        protected final Logger log = LoggerFactory.getLogger(this.getClass());
        private final String ALL = "ALL";
        @Argument(metaVar="<INDEX>|ALL", usage="the key to remove", required=true)
        private List<String> keyParameters = new ArrayList<String>();

        @Override
        public void run() throws IOException, BaseCommand.Failure {
            String username = this.getContext().getClient().getUsername();
            ArrayList<SshKey> registeredKeys = new ArrayList<SshKey>(this.getKeyManager().getKeys(username));
            if (registeredKeys.isEmpty()) {
                throw new BaseCommand.UnloggedFailure(1, "There are no registered keys!");
            }
            if (this.keyParameters.contains("ALL")) {
                if (this.getKeyManager().removeAllKeys(username)) {
                    this.stdout.println("Removed all keys.");
                    this.log.info("removed all SSH public keys from {}", (Object)username);
                } else {
                    this.log.warn("failed to remove all SSH public keys from {}", (Object)username);
                }
            } else {
                for (String keyParameter : this.keyParameters) {
                    try {
                        int index = Integer.parseInt(keyParameter);
                        if (index > registeredKeys.size()) {
                            if (this.keyParameters.size() == 1) {
                                throw new BaseCommand.Failure(1, "Invalid index specified. There is only 1 registered key.");
                            }
                            throw new BaseCommand.Failure(1, String.format("Invalid index specified. There are %d registered keys.", registeredKeys.size()));
                        }
                        SshKey sshKey = (SshKey)registeredKeys.get(index - 1);
                        if (this.getKeyManager().removeKey(username, sshKey)) {
                            this.stdout.println(String.format("Removed %s", sshKey.getFingerprint()));
                            continue;
                        }
                        throw new BaseCommand.Failure(1, String.format("failed to remove #%s: %s", keyParameter, sshKey.getFingerprint()));
                    }
                    catch (NumberFormatException e) {
                        this.log.warn("failed to remove SSH public key {} from {}", (Object)keyParameter, (Object)username);
                        throw new BaseCommand.Failure(1, String.format("failed to remove key %s", keyParameter));
                    }
                }
            }
        }
    }

    @CommandMetaData(name="add", description="Add an SSH public key to your account")
    @UsageExample(syntax="cat ~/.ssh/id_rsa.pub | ${ssh} ${cmd}", description="Upload your SSH public key and add it to your account")
    public static class AddKey
    extends BaseKeyCommand {
        protected final Logger log = LoggerFactory.getLogger(this.getClass());
        @Argument(metaVar="<STDIN>", usage="the key to add")
        private List<String> addKeys = new ArrayList<String>();
        @Option(name="--permission", aliases={"-p"}, metaVar="PERMISSION", usage="set the key access permission")
        private String permission;

        @Override
        protected String getUsageText() {
            String permissions = Joiner.on((String)", ").join((Object[])Constants.AccessPermission.SSHPERMISSIONS);
            StringBuilder sb = new StringBuilder();
            sb.append("Valid SSH public key permissions are:\n   ").append(permissions);
            return sb.toString();
        }

        @Override
        public void run() throws IOException, BaseCommand.Failure {
            String username = this.getContext().getClient().getUsername();
            List<String> keys = this.readKeys(this.addKeys);
            if (keys.isEmpty()) {
                throw new BaseCommand.UnloggedFailure("No public keys were read from STDIN!");
            }
            for (String key : keys) {
                Constants.AccessPermission ap;
                SshKey sshKey = this.parseKey(key);
                try {
                    if (sshKey.getPublicKey() == null) {
                        throw new RuntimeException();
                    }
                }
                catch (RuntimeException e) {
                    throw new BaseCommand.UnloggedFailure("The data read from SDTIN can not be parsed as an SSH public key!");
                }
                if (!StringUtils.isEmpty(this.permission) && (ap = Constants.AccessPermission.fromCode(this.permission)).exceeds(Constants.AccessPermission.NONE)) {
                    try {
                        sshKey.setPermission(ap);
                    }
                    catch (IllegalArgumentException e) {
                        throw new BaseCommand.Failure(1, e.getMessage());
                    }
                }
                this.getKeyManager().addKey(username, sshKey);
                this.log.info("added SSH public key for {}", (Object)username);
            }
        }
    }
}

