/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.models.Activity;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.CommitCache;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import org.eclipse.jgit.lib.Repository;

public class ActivityUtils {
    public static List<Activity> getRecentActivity(IStoredSettings settings, IRepositoryManager repositoryManager, List<RepositoryModel> models, int daysBack, String objectId, TimeZone timezone) {
        Date thresholdDate = new Date(System.currentTimeMillis() - (long)daysBack * 86400000L);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(timezone);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timezone);
        TreeSet<String> authorExclusions = new TreeSet<String>();
        authorExclusions.addAll(settings.getStrings("web.metricAuthorExclusions"));
        for (RepositoryModel model : models) {
            if (ArrayUtils.isEmpty(model.metricAuthorExclusions)) continue;
            authorExclusions.addAll(model.metricAuthorExclusions);
        }
        HashMap<String, Activity> activity = new HashMap<String, Activity>();
        for (RepositoryModel model : models) {
            if (!model.isShowActivity() || !model.hasCommits || !model.lastChange.after(thresholdDate) || model.isCollectingGarbage) continue;
            Repository repository = repositoryManager.getRepository(model.name);
            ArrayList<String> branches = new ArrayList<String>();
            if (StringUtils.isEmpty(objectId)) {
                for (RefModel local : JGitUtils.getLocalBranches(repository, true, -1)) {
                    if (!local.getDate().after(thresholdDate)) continue;
                    branches.add(local.getName());
                }
            } else {
                branches.add(objectId);
            }
            for (String branch : branches) {
                String shortName = branch;
                if (shortName.startsWith("refs/heads/")) {
                    shortName = shortName.substring("refs/heads/".length());
                }
                List<RepositoryCommit> commits = CommitCache.instance().getCommits(model.name, repository, branch, thresholdDate);
                if (model.maxActivityCommits > 0 && commits.size() > model.maxActivityCommits) {
                    commits = commits.subList(0, model.maxActivityCommits);
                }
                for (RepositoryCommit commit : commits) {
                    Date date = commit.getCommitDate();
                    String dateStr = df.format(date);
                    if (!activity.containsKey(dateStr)) {
                        cal.setTime(date);
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        Activity a = new Activity(cal.getTime());
                        a.excludeAuthors(authorExclusions);
                        activity.put(dateStr, a);
                    }
                    ((Activity)activity.get(dateStr)).addCommit(commit);
                }
            }
            repository.close();
        }
        ArrayList<Activity> recentActivity = new ArrayList<Activity>(activity.values());
        return recentActivity;
    }

    public static String getGravatarIdenticonUrl(String email, int width) {
        if (width <= 0) {
            width = 50;
        }
        String emailHash = StringUtils.getMD5(email.toLowerCase());
        String url = MessageFormat.format("https://www.cnavatar.com/avatar/{0}?s={1,number,0}&d=identicon", emailHash, width);
        return url;
    }

    public static String getGravatarThumbnailUrl(String email, int width) {
        if (width <= 0) {
            width = 50;
        }
        String emailHash = StringUtils.getMD5(email.toLowerCase());
        String url = MessageFormat.format("https://www.cnavatar.com/avatar/{0}?s={1,number,0}&d=mm", emailHash, width);
        return url;
    }
}

