/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ArrayUtils {
    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static String toString(Collection<?> collection) {
        if (ArrayUtils.isEmpty(collection)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : collection) {
            sb.append(o.toString()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public static Collection<String> fromString(String value) {
        String[] values;
        if (StringUtils.isEmpty(value)) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String v : values = value.split(",|;")) {
            String string = v.trim();
            if (StringUtils.isEmpty(string)) continue;
            list.add(string);
        }
        return list;
    }

    public static <X> List<X> join(List<X> ... elements) {
        ArrayList<X> list = new ArrayList<X>();
        for (List<X> element : elements) {
            list.addAll(element);
        }
        return list;
    }

    public static <X> List<X> join(X[] ... elements) {
        ArrayList<X> list = new ArrayList<X>();
        for (X[] element : elements) {
            list.addAll(Arrays.asList(element));
        }
        return list;
    }
}

