/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ColorFactory {
    private static final double MAX_TINT_FACTOR = 1.0;
    private static final double MIN_TINT_FACTOR = 0.2;
    private static final double FIXED_TINT_FACTOR = 0.875;

    public <T> Map<T, String> getGraduatedColorMap(Set<T> keys, Color baseColor) {
        HashMap<T, String> colorMap = new HashMap<T, String>();
        if (baseColor == null) {
            baseColor = this.getRandomColor();
        }
        double tintStep = 0.8 / (double)keys.size();
        double currentTint = 1.0;
        for (T key : keys) {
            Color color = this.tintColor(baseColor, currentTint);
            colorMap.put(key, this.getColorString(color));
            currentTint -= tintStep;
        }
        return colorMap;
    }

    public <T> Map<T, String> getRandomColorMap(Set<T> keys) {
        HashMap<T, String> colorMap = new HashMap<T, String>();
        for (T key : keys) {
            Color color = this.tintColor(this.getRandomColor(), 0.875);
            colorMap.put(key, this.getColorString(color));
        }
        return colorMap;
    }

    private Color getRandomColor() {
        Random random = new Random();
        Color randomColor = new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
        return randomColor;
    }

    private Color tintColor(Color origColor, double tintFactor) {
        int tintedRed = this.applyTint(origColor.getRed(), tintFactor);
        int tintedGreen = this.applyTint(origColor.getGreen(), tintFactor);
        int tintedBlue = this.applyTint(origColor.getBlue(), tintFactor);
        Color tintedColor = new Color(tintedRed, tintedGreen, tintedBlue);
        return tintedColor;
    }

    private String getColorString(Color color) {
        return "#" + Integer.toHexString(color.getRGB() & 0xFFFFFF);
    }

    private int applyTint(int color, double tintFactor) {
        return (int)((double)color + (double)(255 - color) * tintFactor);
    }
}

