/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.IStoredSettings;
import java.io.CharConversionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(ContainerUtils.class);

    public static class CVE_2007_0450 {
        public static void test(IStoredSettings settings) {
            boolean mounted = settings.getBoolean("web.mountParameters", true);
            char fsc = settings.getChar("web.forwardSlashCharacter", '/');
            if (mounted && (fsc == '/' || fsc == '\\')) {
                CVE_2007_0450.logCVE_2007_0450Tomcat(settings);
            }
        }

        private static boolean logCVE_2007_0450Tomcat(IStoredSettings settings) {
            try {
                byte[] test = "http://server.domain:8080/context/servlet/param%2fparam".getBytes();
                Class<?> cByteChunk = Class.forName("org.apache.tomcat.util.buf.ByteChunk");
                Object mb = cByteChunk.newInstance();
                Method setBytes = cByteChunk.getMethod("setBytes", byte[].class, Integer.TYPE, Integer.TYPE);
                setBytes.invoke(mb, test, 0, test.length);
                Class<?> cUDecoder = Class.forName("org.apache.tomcat.util.buf.UDecoder");
                Object ud = cUDecoder.newInstance();
                Method convert = cUDecoder.getMethod("convert", cByteChunk, Boolean.TYPE);
                try {
                    convert.invoke(ud, mb, false);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null && e.getTargetException() instanceof CharConversionException) {
                        LOGGER.warn("You are using a Tomcat-based server and your current settings will prevent grouped repositories, forks, personal repositories, and tree navigation from working properly. Please review the FAQ for details about running Gitblit on Tomcat. http://gitblit.com/faq.html and http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0450");
                        LOGGER.warn("Overriding {} and setting to {}", (Object)"web.forwardSlashCharacter", (Object)"!");
                        settings.overrideSetting("web.forwardSlashCharacter", "!");
                        return true;
                    }
                    throw e;
                }
            }
            catch (Throwable t) {
                if (t instanceof ClassNotFoundException || t instanceof NoSuchMethodException || t instanceof IllegalArgumentException) {
                    return false;
                }
                LOGGER.debug("This is a tomcat, but the test operation failed somehow", t);
            }
            return true;
        }
    }
}

