/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.XssFilter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

@Singleton
public class JSoupXssFilter
implements XssFilter {
    private final Cleaner none = new Cleaner(Whitelist.none());
    private final Cleaner relaxed = new Cleaner(this.getRelaxedWhiteList());

    @Inject
    public JSoupXssFilter() {
    }

    @Override
    public String none(String input) {
        return this.clean(input, this.none);
    }

    @Override
    public String relaxed(String input) {
        return this.clean(input, this.relaxed);
    }

    protected String clean(String input, Cleaner cleaner) {
        Document unsafe = Jsoup.parse((String)input);
        Document safe = cleaner.clean(unsafe);
        return safe.body().html();
    }

    protected Whitelist getRelaxedWhiteList() {
        return new Whitelist().addTags(new String[]{"a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "del", "div", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "kbd", "li", "ol", "p", "pre", "q", "samp", "small", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "tt", "u", "ul", "var"}).addAttributes("a", new String[]{"class", "href", "style", "target", "title"}).addAttributes("blockquote", new String[]{"cite"}).addAttributes("col", new String[]{"span", "width"}).addAttributes("colgroup", new String[]{"span", "width"}).addAttributes("div", new String[]{"class", "style"}).addAttributes("img", new String[]{"align", "alt", "height", "src", "title", "width"}).addAttributes("ol", new String[]{"start", "type"}).addAttributes("q", new String[]{"cite"}).addAttributes("span", new String[]{"class", "style"}).addAttributes("table", new String[]{"class", "style", "summary", "width"}).addAttributes("td", new String[]{"abbr", "axis", "class", "colspan", "rowspan", "style", "width"}).addAttributes("th", new String[]{"abbr", "axis", "class", "colspan", "rowspan", "scope", "style", "width"}).addAttributes("ul", new String[]{"type"}).addEnforcedAttribute("a", "rel", "nofollow");
    }
}

