/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.FileUtils;
import java.io.File;
import java.nio.file.Path;

public class LuceneIndexStore {
    public static final int LUCENE_CODEC_VERSION = 54;
    protected File indexFolder;

    public LuceneIndexStore(File luceneFolder, int indexVersion) {
        this.indexFolder = new File(luceneFolder, indexVersion + "_" + 54);
    }

    public void create() {
        if (!this.indexFolder.exists()) {
            this.indexFolder.mkdirs();
        }
    }

    public boolean delete() {
        if (this.indexFolder.exists()) {
            return FileUtils.delete(this.indexFolder);
        }
        return true;
    }

    public Path getPath() {
        return this.indexFolder.toPath();
    }

    public boolean hasIndex() {
        return this.indexFolder.exists() && this.indexFolder.isDirectory() && this.indexFolder.list().length > 1;
    }
}

