/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.IStoredSettings;
import com.gitblit.wicket.MarkupProcessor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.pegdown.LinkRenderer;
import org.pegdown.ParsingTimeoutException;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.RootNode;

public class MarkdownUtils {
    public static String transformPlainText(String text) {
        text = text.replaceAll("((http|https)://[0-9A-Za-z-_=\\?\\.\\$#&/]*)", "<a href=\"$1\">$1</a>");
        String html = "<pre>" + text + "</pre>";
        return html;
    }

    public static String transformMarkdown(String markdown) {
        return MarkdownUtils.transformMarkdown(markdown, null);
    }

    public static String transformMarkdown(String markdown, LinkRenderer linkRenderer) {
        try {
            PegDownProcessor pd = new PegDownProcessor(64764);
            RootNode astRoot = pd.parseMarkdown(markdown.toCharArray());
            return new MarkupProcessor.WorkaroundHtmlSerializer(linkRenderer == null ? new LinkRenderer() : linkRenderer).toHtml(astRoot);
        }
        catch (ParsingTimeoutException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String transformMarkdown(Reader markdownReader) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((Reader)markdownReader, (Writer)writer);
            String markdown = writer.toString();
            String string = MarkdownUtils.transformMarkdown(markdown);
            return string;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String transformGFM(IStoredSettings settings, String input, String repositoryName) {
        String text = input;
        text = text.replaceAll("~~(.*)~~", "<s>$1</s>");
        text = text.replaceAll("\\{(?:-){2}(.*)(?:-){2}}", "<s>$1</s>");
        text = text.replaceAll("\\{(?:\\+){2}(.*)(?:\\+){2}}", "<u>$1</u>");
        text = text.replaceAll("\\{~~(.*)~>(.*)~~}", "<s>$1</s><u>$2</u>");
        text = text.replaceAll("\\{==(.*)==}", "<span class='highlight'>$1</span>");
        String canonicalUrl = settings.getString("web.canonicalUrl", "https://localhost:8443");
        String mentionReplacement = String.format("**[@${user}](%1s/user/${user})**", canonicalUrl);
        text = text.replaceAll("\\B@(?<user>[^\\s]+)\\b", mentionReplacement);
        String ticketReplacement = MessageFormat.format("$1[#$2]({0}/tickets?r={1}&h=$2)$3", canonicalUrl, repositoryName);
        text = text.replaceAll("([\\s,]+)#(\\d+)([\\s,:\\.\\n])", ticketReplacement);
        int shaLen = settings.getInteger("web.shortCommitIdLength", 6);
        String commitPattern = MessageFormat.format("\\s([A-Fa-f0-9]'{'{0}'}')([A-Fa-f0-9]'{'{1}'}')", shaLen, 40 - shaLen);
        String commitReplacement = String.format(" [`$1`](%1$s/commit?r=%2$s&h=$1$2)", canonicalUrl, repositoryName);
        text = text.replaceAll(commitPattern, commitReplacement);
        String html = MarkdownUtils.transformMarkdown(text);
        return html;
    }
}

