/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectCache<X>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, CachedObject<X>> cache = new ConcurrentHashMap<String, CachedObject<X>>();

    public void clear() {
        this.cache.clear();
    }

    public boolean hasCurrent(String name, Date date) {
        return this.cache.containsKey(name) && ((CachedObject)this.cache.get(name)).date.compareTo(date) == 0;
    }

    public Date getDate(String name) {
        return ((CachedObject)this.cache.get(name)).date;
    }

    public X getObject(String name) {
        if (this.cache.containsKey(name)) {
            return (X)((CachedObject)this.cache.get(name)).object;
        }
        return null;
    }

    public void updateObject(String name, X object) {
        this.updateObject(name, new Date(), object);
    }

    public void updateObject(String name, Date date, X object) {
        CachedObject<Object> obj;
        if (this.cache.containsKey(name)) {
            obj = this.cache.get(name);
        } else {
            obj = new CachedObject(name);
            this.cache.put(name, obj);
        }
        ((CachedObject)obj).date = date;
        ((CachedObject)obj).object = object;
    }

    public X remove(String name) {
        if (this.cache.containsKey(name)) {
            return (X)((CachedObject)this.cache.remove(name)).object;
        }
        return null;
    }

    public int size() {
        return this.cache.size();
    }

    private class CachedObject<Y> {
        public final String name;
        private volatile Date date;
        private volatile Y object;

        CachedObject(String name) {
            this.name = name;
            this.date = new Date(0L);
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.name;
        }
    }
}

