/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.PasswordHashPbkdf2;
import com.gitblit.utils.StringUtils;
import java.util.Arrays;

public abstract class PasswordHash {
    final Type type;

    PasswordHash(Type type) {
        this.type = type;
    }

    public static Type getDefaultType() {
        return Type.PBKDF2;
    }

    public static PasswordHash instanceOf(String type) {
        Type hashType = Type.fromName(type);
        if (hashType == null) {
            return null;
        }
        switch (hashType) {
            case MD5: {
                return new PasswordHashMD5();
            }
            case CMD5: {
                return new PasswordHashCombinedMD5();
            }
            case PBKDF2: {
                return new PasswordHashPbkdf2();
            }
        }
        return null;
    }

    public static PasswordHash instanceFor(String hashedEntry) {
        Type type = PasswordHash.getEntryType(hashedEntry);
        if (type != null) {
            return PasswordHash.instanceOf(type.name());
        }
        return null;
    }

    public static boolean isHashedEntry(String storedPassword) {
        return null != PasswordHash.getEntryType(storedPassword);
    }

    public boolean needsUpgradeTo(String algorithm) {
        Type hashType = Type.fromName(algorithm);
        if (hashType == null) {
            return false;
        }
        if (this.type == hashType) {
            return false;
        }
        return hashType == Type.PBKDF2;
    }

    public abstract String toHashedEntry(char[] var1, String var2);

    public String toHashedEntry(String password, String username) {
        if (password == null) {
            throw new IllegalArgumentException("The password argument may not be null when hashing a password.");
        }
        return this.toHashedEntry(password.toCharArray(), username);
    }

    public boolean matches(String hashedEntry, char[] password, String username) {
        if (hashedEntry == null || this.type != PasswordHash.getEntryType(hashedEntry)) {
            return false;
        }
        if (password == null) {
            return false;
        }
        String hashed = this.toHashedEntry(password, username);
        Arrays.fill(password, '\u0000');
        return hashed.equalsIgnoreCase(hashedEntry);
    }

    static Type getEntryType(String hashedEntry) {
        if (hashedEntry == null) {
            return null;
        }
        int indexOfSeparator = hashedEntry.indexOf(58);
        if (indexOfSeparator <= 0) {
            return null;
        }
        String typeId = hashedEntry.substring(0, indexOfSeparator);
        return Type.fromName(typeId);
    }

    static String getEntryValue(String hashedEntry) {
        if (hashedEntry == null) {
            return null;
        }
        int indexOfSeparator = hashedEntry.indexOf(58);
        return hashedEntry.substring(indexOfSeparator + 1);
    }

    private static class PasswordHashCombinedMD5
    extends PasswordHash {
        PasswordHashCombinedMD5() {
            super(Type.CMD5);
        }

        @Override
        public String toHashedEntry(char[] password, String username) {
            if (password == null) {
                throw new IllegalArgumentException("The password argument may not be null when hashing a password.");
            }
            return this.toHashedEntry(new String(password), username);
        }

        @Override
        public String toHashedEntry(String password, String username) {
            if (password == null) {
                throw new IllegalArgumentException("The password argument may not be null when hashing a password.");
            }
            if (username == null) {
                throw new IllegalArgumentException("The username argument may not be null when hashing a password with Combined-MD5.");
            }
            if (StringUtils.isEmpty(username)) {
                throw new IllegalArgumentException("The username argument may not be empty when hashing a password with Combined-MD5.");
            }
            return this.type.name() + ":" + StringUtils.getMD5(username.toLowerCase() + password);
        }

        @Override
        public boolean matches(String hashedEntry, char[] password, String username) {
            if (username == null || StringUtils.isEmpty(username)) {
                return false;
            }
            return super.matches(hashedEntry, password, username);
        }
    }

    private static class PasswordHashMD5
    extends PasswordHash {
        PasswordHashMD5() {
            super(Type.MD5);
        }

        @Override
        public String toHashedEntry(char[] password, String username) {
            if (password == null) {
                throw new IllegalArgumentException("The password argument may not be null when hashing a password.");
            }
            return this.toHashedEntry(new String(password), username);
        }

        @Override
        public String toHashedEntry(String password, String username) {
            if (password == null) {
                throw new IllegalArgumentException("The password argument may not be null when hashing a password.");
            }
            return this.type.name() + ":" + StringUtils.getMD5(password);
        }
    }

    public static enum Type {
        MD5,
        CMD5,
        PBKDF2;


        static Type fromName(String name) {
            if (name == null) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            if (name.equalsIgnoreCase("PBKDF2WITHHMACSHA256")) {
                return PBKDF2;
            }
            if (name.equalsIgnoreCase("combined-md5")) {
                return CMD5;
            }
            return null;
        }
    }
}

